/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.Environment;
import freemarker.core.ParameterRole;
import freemarker.core.TemplateElement;
import freemarker.template.TemplateException;
import freemarker.template.utility.StandardCompress;
import java.io.IOException;

final class CompressedBlock
extends TemplateElement {
    CompressedBlock(TemplateElement nestedBlock) {
        this.setNestedBlock(nestedBlock);
    }

    void accept(Environment env) throws TemplateException, IOException {
        if (this.getNestedBlock() != null) {
            env.visitAndTransform(this.getNestedBlock(), StandardCompress.INSTANCE, null);
        }
    }

    protected String dump(boolean canonical) {
        if (canonical) {
            String nested = this.getNestedBlock() != null ? this.getNestedBlock().getCanonicalForm() : "";
            return "<" + this.getNodeTypeSymbol() + ">" + nested + "</" + this.getNodeTypeSymbol() + ">";
        }
        return this.getNodeTypeSymbol();
    }

    String getNodeTypeSymbol() {
        return "#compress";
    }

    int getParameterCount() {
        return 0;
    }

    Object getParameterValue(int idx) {
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        throw new IndexOutOfBoundsException();
    }

    boolean isIgnorable() {
        return this.getNestedBlock() == null || this.getNestedBlock().isIgnorable();
    }

    boolean isNestedBlockRepeater() {
        return false;
    }
}

