/*
 * Decompiled with CFR 0.152.
 */
package de.citunius.bbp.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.citunius.bbp.objects.MobileDevice;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class MobileUserAccount {
    static Logger logger = Logger.getLogger((String)LogManager.class.getName());
    public static final String TENANTID_FIELD = "tenant_id";
    @JsonProperty(value="tenant_id")
    String tenantId;
    public static final String ACCOUNTID_FIELD = "account_id";
    @JsonProperty(value="account_id")
    String accountId;
    public static final String ID_FIELD = "id";
    @JsonProperty(value="id")
    int id;
    public static final String USERNAME_FIELD = "username";
    @JsonProperty(value="username")
    String username;
    public static final String TSCREATED_FIELD = "tscreated";
    @JsonProperty(value="tscreated")
    Date tsCreated;
    public static final String TSSYNCHRONIZED_FIELD = "tssynchronized";
    @JsonProperty(value="tssynchronized")
    Date tsSynchronized;
    public static final String ISINACIVE_FIELD = "isinactive";
    @JsonProperty(value="isinactive")
    boolean isInactive;
    public static final String FIRSTNAME_FIELD = "firstname";
    @JsonProperty(value="firstname")
    String firstName;
    public static final String LASTNAME_FIELD = "lastname";
    @JsonProperty(value="lastname")
    String lastName;
    public static final String ISADMINISTRATIVE_FIELD = "isadministrative";
    @JsonProperty(value="isadministrative")
    boolean isAdministrative;
    public static final String MOBILEDEVICES_FIELD = "mobildevices";
    @JsonProperty(value="mobildevices")
    List<MobileDevice> mobilDevices;
    public static final String PRIMARYMOBILEDEVICE_FIELD = "primarymobiledevice";
    @JsonProperty(value="primarymobiledevice")
    MobileDevice primaryMobileDevice;

    public MobileUserAccount() {
    }

    public MobileUserAccount(String tenantId, String accountId, int id, String username, Date tsCreated, Date tsSynchronized, boolean isInactive, String firstName, String lastName, boolean isAdministrative, List<MobileDevice> mobilDevices, MobileDevice primaryMobileDevice) {
        this.tenantId = tenantId;
        this.accountId = accountId;
        this.id = id;
        this.username = username;
        this.tsCreated = tsCreated;
        this.tsSynchronized = tsSynchronized;
        this.isInactive = isInactive;
        this.firstName = firstName;
        this.lastName = lastName;
        this.isAdministrative = isAdministrative;
        this.mobilDevices = mobilDevices;
        this.primaryMobileDevice = primaryMobileDevice;
    }

    public MobileUserAccount(JSONObject jsonObject) {
        SimpleDateFormat originalFormat = new SimpleDateFormat("yyyyMMdd");
        if (jsonObject.has(TENANTID_FIELD)) {
            this.tenantId = jsonObject.getString(TENANTID_FIELD);
        }
        if (jsonObject.has(ACCOUNTID_FIELD)) {
            this.accountId = jsonObject.getString(ACCOUNTID_FIELD);
        }
        this.id = jsonObject.getInt(ID_FIELD);
        if (jsonObject.has(USERNAME_FIELD)) {
            this.username = jsonObject.getString(USERNAME_FIELD);
        }
        try {
            if (jsonObject.has(TSCREATED_FIELD)) {
                this.tsCreated = originalFormat.parse("" + jsonObject.getInt(TSCREATED_FIELD));
            }
            if (jsonObject.has(TSSYNCHRONIZED_FIELD)) {
                this.tsSynchronized = originalFormat.parse("" + jsonObject.getInt(TSSYNCHRONIZED_FIELD));
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (jsonObject.has(ISINACIVE_FIELD)) {
            this.isInactive = jsonObject.getBoolean(ISINACIVE_FIELD);
        }
        if (jsonObject.has(FIRSTNAME_FIELD)) {
            this.firstName = jsonObject.getString(FIRSTNAME_FIELD);
        }
        if (jsonObject.has(LASTNAME_FIELD)) {
            this.lastName = jsonObject.getString(LASTNAME_FIELD);
        }
        if (jsonObject.has(ISADMINISTRATIVE_FIELD)) {
            this.isAdministrative = jsonObject.getBoolean(ISADMINISTRATIVE_FIELD);
        }
        if (jsonObject.has(MOBILEDEVICES_FIELD)) {
            this.mobilDevices = new ArrayList<MobileDevice>();
            JSONArray mobilDevices = jsonObject.getJSONArray(MOBILEDEVICES_FIELD);
            for (int i = 0; i < mobilDevices.length(); ++i) {
                this.mobilDevices.add(new MobileDevice(mobilDevices.getJSONObject(i)));
            }
        } else {
            logger.error((Object)("MobileUserAccount [" + this.id + "] has no mobile devices defined!"));
        }
        if (jsonObject.has(PRIMARYMOBILEDEVICE_FIELD)) {
            this.primaryMobileDevice = new MobileDevice(jsonObject.getJSONObject(PRIMARYMOBILEDEVICE_FIELD));
        } else {
            logger.error((Object)("MobileUserAccount [" + this.id + "] has no primary mobile device defined!"));
        }
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int newId) {
        this.id = newId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String newUsername) {
        this.username = newUsername;
    }

    public Date getTsCreated() {
        return this.tsCreated;
    }

    public void setTo(Date newTsCreated) {
        this.tsCreated = newTsCreated;
    }

    public Date getTsSynchronized() {
        return this.tsSynchronized;
    }

    public void setTsSynchronized(Date newTsSynchronized) {
        this.tsSynchronized = newTsSynchronized;
    }

    public boolean isInactive() {
        return this.isInactive;
    }

    public void setInactive(boolean isInactive) {
        this.isInactive = isInactive;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public boolean getIsAdministrative() {
        return this.isAdministrative;
    }

    public void setIsAdministrative(boolean isAdministrative) {
        this.isAdministrative = isAdministrative;
    }

    public List<MobileDevice> getMobileDevices() {
        return this.mobilDevices;
    }

    public void setMobileDevices(List<MobileDevice> mobilDevices) {
        this.mobilDevices = mobilDevices;
    }

    public MobileDevice getPrimaryMobileDevice() {
        return this.primaryMobileDevice;
    }

    public void setPrimaryMobileDevice1(MobileDevice primaryMobileDevice) {
        this.primaryMobileDevice = primaryMobileDevice;
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        if (this.tenantId != null) {
            jsonObject.put(TENANTID_FIELD, (Object)this.tenantId);
        }
        if (this.accountId != null) {
            jsonObject.put(ACCOUNTID_FIELD, (Object)this.accountId);
        }
        jsonObject.put(ID_FIELD, this.id);
        if (this.username != null) {
            jsonObject.put(USERNAME_FIELD, (Object)this.username);
        }
        if (this.tsCreated != null) {
            jsonObject.put(TSCREATED_FIELD, this.tsCreated.getTime());
        }
        if (this.tsSynchronized != null) {
            jsonObject.put(TSSYNCHRONIZED_FIELD, this.tsSynchronized.getTime());
        }
        jsonObject.put(ISINACIVE_FIELD, this.isInactive);
        if (this.firstName != null) {
            jsonObject.put(FIRSTNAME_FIELD, (Object)this.firstName);
        }
        if (this.lastName != null) {
            jsonObject.put(LASTNAME_FIELD, (Object)this.lastName);
        }
        jsonObject.put(ISADMINISTRATIVE_FIELD, this.isAdministrative);
        if (this.mobilDevices != null) {
            JSONArray mobilDevicesJsonArray = new JSONArray();
            for (int i = 0; i < this.mobilDevices.size(); ++i) {
                mobilDevicesJsonArray.put((Object)this.mobilDevices.get(i).toJson());
            }
            jsonObject.put(MOBILEDEVICES_FIELD, (Object)mobilDevicesJsonArray);
        }
        if (this.primaryMobileDevice != null) {
            jsonObject.put(PRIMARYMOBILEDEVICE_FIELD, (Object)this.primaryMobileDevice.toJson());
        }
        return jsonObject;
    }

    public String toString() {
        return "MobileUserAccount [tenantId=" + this.tenantId + ", accountId=" + this.accountId + ", id=" + this.id + ", username=" + this.username + ", tsCreated=" + this.tsCreated + ", tsSynchronized=" + this.tsSynchronized + ", isInactive=" + this.isInactive + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", isAdministrative=" + this.isAdministrative + ", mobilDevices=" + this.mobilDevices + ", primaryMobileDevice=" + this.primaryMobileDevice + "]";
    }
}

