/*
 * Decompiled with CFR 0.152.
 */
package de.citunius.businesslogicapi.common;

import de.citunius.bbp.objects.MobileAppSetting;
import de.citunius.bbp.objects.MobileUserAccount;
import de.citunius.bbp.objects.Userstate;
import de.citunius.businesslogicapi.common.ConstantsPlugin;
import de.citunius.businesslogicapi.common.services.WebService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class Utilities {
    static Logger logger = Logger.getLogger((String)LogManager.class.getName());

    public String getNewLongDateByFormat(String longDateFormat) {
        SimpleDateFormat dataFormat = new SimpleDateFormat(longDateFormat);
        return dataFormat.format(new Date());
    }

    public static String getMobileAppSettingValue(String parameter, MobileUserAccount mobileUserAccount) {
        String parameterValue = null;
        if (mobileUserAccount != null) {
            if (mobileUserAccount.getMobileDevices() != null && mobileUserAccount.getMobileDevices().size() != 0) {
                for (int d = 0; d < mobileUserAccount.getMobileDevices().size(); ++d) {
                    if (mobileUserAccount.getMobileDevices().get(d).getMobileApps() != null && mobileUserAccount.getMobileDevices().get(d).getMobileApps().size() != 0) {
                        for (int a = 0; a < mobileUserAccount.getMobileDevices().get(d).getMobileApps().size(); ++a) {
                            List<MobileAppSetting> mobileAppSettings = mobileUserAccount.getMobileDevices().get(d).getMobileApps().get(a).getMobileAppSettings();
                            if (mobileAppSettings != null) {
                                for (int i = 0; i < mobileAppSettings.size(); ++i) {
                                    if (!mobileAppSettings.get(i).getParameter().equals(parameter)) continue;
                                    if (parameterValue == null) {
                                        logger.warn((Object)("Parameter value already found (Duplicate parameter [" + parameter + "] found for MobileUserAccount [" + mobileUserAccount.getId() + "]"));
                                    }
                                    parameterValue = mobileAppSettings.get(i).getValue();
                                }
                                continue;
                            }
                            logger.error((Object)("MobileUserAccount has MobileApp [" + mobileUserAccount.getMobileDevices().get(d).getMobileApps().get(a).getId() + "] but no MobileAppSettings"));
                        }
                        continue;
                    }
                    logger.error((Object)("MobileUserAccount has MobileDevice [" + mobileUserAccount.getMobileDevices().get(d).getId() + "] but no MobileApps"));
                }
            } else {
                logger.error((Object)"MobileUserAccount has no MobileDevices");
            }
        } else {
            logger.error((Object)"MobileUserAccount is NULL");
        }
        logger.error((Object)("Return value [" + parameterValue + "] for parameter [" + parameter + "]"));
        return parameterValue;
    }

    public static String getMobileAppSettingValue(String parameter, List<MobileAppSetting> mobileAppSettings) {
        if (null != mobileAppSettings) {
            for (int i = 0; i < mobileAppSettings.size(); ++i) {
                if (!mobileAppSettings.get(i).getParameter().equals(parameter)) continue;
                return mobileAppSettings.get(i).getValue();
            }
        }
        return null;
    }

    public static String getMobileAppSettingParameterNameUserId(String tenantId, String accountId, HashMap<String, String> pluginMap) {
        if (pluginMap.containsKey(ConstantsPlugin.MESSENGER_NAME)) {
            if (pluginMap.get(ConstantsPlugin.MESSENGER_NAME).equals("FacebookMessenger")) {
                return "FacebookMessenger.UserInfo.UserId";
            }
            if (pluginMap.get(ConstantsPlugin.MESSENGER_NAME).equals("SkypeForBusiness")) {
                return "SkypeForBusiness.UserInfo.SipUri";
            }
            if (pluginMap.get(ConstantsPlugin.MESSENGER_NAME).equals("Slack")) {
                return "Slack.UserInfo.UserId";
            }
            if (pluginMap.get(ConstantsPlugin.MESSENGER_NAME).equals("Telegram")) {
                return "Telegram.UserInfo.UserId";
            }
            if (pluginMap.get(ConstantsPlugin.MESSENGER_NAME).equals("Threema")) {
                return "Threema.UserInfo.UserId";
            }
            if (pluginMap.get(ConstantsPlugin.MESSENGER_NAME).equals("XMPP")) {
                return "XMPP.UserInfo.Username";
            }
            logger.fatal((Object)("Unknown messenger in PluginMap [" + ConstantsPlugin.MESSENGER_NAME + "]"));
        } else {
            logger.fatal((Object)("PluginMap does not contain [" + ConstantsPlugin.MESSENGER_NAME + "]"));
        }
        return null;
    }

    public static String getMobileAppSettingParameterNameUserId(String tenantId, String accountId, String providerName) {
        if (providerName != null) {
            if (providerName.equals("FacebookMessenger")) {
                return "FacebookMessenger.UserInfo.UserId";
            }
            if (providerName.equals("SkypeForBusiness")) {
                return "SkypeForBusiness.UserInfo.SipUri";
            }
            if (providerName.equals("Slack")) {
                return "Slack.UserInfo.UserId";
            }
            if (providerName.equals("Telegram")) {
                return "Telegram.UserInfo.UserId";
            }
            if (providerName.equals("Threema")) {
                return "Threema.UserInfo.UserId";
            }
            if (providerName.equals("XMPP")) {
                return "XMPP.UserInfo.Username";
            }
            logger.fatal((Object)("Unknown messenger in PluginMap [" + ConstantsPlugin.MESSENGER_NAME + "]"));
        } else {
            logger.fatal((Object)"providerName is NULL");
        }
        return null;
    }

    public static boolean updateUserState(String tenantId, String accountId, String pluginName, HashMap<String, String> pluginMap, String userId, int userstate, String defaultLanguage) {
        Userstate userstateObj = new Userstate(pluginMap.get(ConstantsPlugin.PLUGIN_NAME), userId, "" + userstate, defaultLanguage);
        WebService ws = new WebService(pluginMap);
        return ws.setUserstate(userstateObj);
    }

    public static Userstate getUserState(String tenantId, String accountId, String pluginName, HashMap<String, String> pluginMap, String userId) {
        WebService ws = new WebService(pluginMap);
        Userstate userstate = new Userstate(pluginMap.get(ConstantsPlugin.PLUGIN_NAME), userId, null, null);
        List<Userstate> userstateList = ws.getUserstate(userstate);
        if (userstateList != null && userstateList.size() != 0) {
            if (userstateList.size() == 1) {
                return userstateList.get(0);
            }
            logger.error((Object)("Found multiple user states for userId [" + userId + "], using the first result: [" + userstateList.get(0).getUserLanguageCode() + "]"));
            return userstateList.get(0);
        }
        logger.info((Object)("No user state found for userId [" + userId + "]@[" + pluginName + "]"));
        return null;
    }

    public static String getAttributeFromPropertiesFile(HashMap<String, String> pluginMap, String parameter) {
        String filename = "config.properties";
        String pluginSystemDir = pluginMap.get(ConstantsPlugin.PLUGIN_SYSTEMDIR);
        String dbFilePathUrl = pluginSystemDir + File.separator + pluginMap.get(ConstantsPlugin.PLUGIN_RESOURCE_PATH) + File.separator + filename;
        String value = null;
        Properties prop = new Properties();
        try {
            FileInputStream in = new FileInputStream(dbFilePathUrl);
            prop.load(in);
            value = prop.getProperty(parameter);
        }
        catch (IOException ex) {
            logger.error((Object)("Unable to read parameter from properties file [" + dbFilePathUrl + "]"));
            ex.printStackTrace();
        }
        if (value == null || value.length() == 0) {
            logger.warn((Object)("Parameter [" + parameter + "] not found in properties file [" + dbFilePathUrl + "]"));
        } else {
            logger.debug((Object)("Parameter [" + parameter + "] -> Value: [" + value + "] found in properties file"));
        }
        return value;
    }

    public static String abbreviate(String str, int length) {
        if (str.length() > length) {
            return str.substring(0, length) + "...";
        }
        return str;
    }

    public static <T, E> T getKeyByValue(Map<T, E> map, E value) {
        for (Map.Entry<T, E> entry : map.entrySet()) {
            if (!Objects.equals(value, entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public static boolean parameterExists(Map<String, String[]> parameterMap, String name) {
        Map<String, String[]> allMap = parameterMap;
        for (String key : allMap.keySet()) {
            String[] strArr;
            if (!key.equals(name) || (strArr = allMap.get(key)).length != 1) continue;
            logger.info((Object)("Found parameter: [" + key + "] -> value: [" + strArr[0] + "]"));
            return true;
        }
        return false;
    }

    public static String getFormattedTimestamp(Date date, String dateFormat) {
        SimpleDateFormat format = new SimpleDateFormat(dateFormat, Locale.ENGLISH);
        if (null != date) {
            return format.format(date);
        }
        return "";
    }

    public static String getParameter(Map<String, String[]> parameterMap, String name) {
        Map<String, String[]> allMap = parameterMap;
        for (String key : allMap.keySet()) {
            String[] strArr;
            if (!key.equals(name) || (strArr = allMap.get(key)).length != 1) continue;
            logger.info((Object)("Found parameter: [" + key + "] -> value: [" + strArr[0] + "]"));
            return strArr[0];
        }
        return null;
    }

    public static String[] getParameterValues(Map<String, String[]> parameterMap, String name) {
        Map<String, String[]> allMap = parameterMap;
        for (String key : allMap.keySet()) {
            if (!key.equals(name)) continue;
            String[] strArr = allMap.get(key);
            logger.info((Object)("Found parameter: [" + key + "] -> values: [" + strArr + "]"));
            return strArr;
        }
        return null;
    }

    public static List<String> getParameterNames(Map<String, String[]> parameterMap) {
        LinkedList<String> keys = new LinkedList<String>();
        Map<String, String[]> allMap = parameterMap;
        for (String key : allMap.keySet()) {
            keys.add(key);
        }
        return keys;
    }

    public static void printParameterMap(Map<String, String[]> parameterMap) {
        Map<String, String[]> allMap = parameterMap;
        for (String key : allMap.keySet()) {
            String[] strArr = allMap.get(key);
            if (strArr.length == 1) {
                logger.info((Object)("ParameterMap -> Key: [" + key + "] Value: [" + strArr[0] + "]"));
                continue;
            }
            int count = 0;
            for (String val : strArr) {
                logger.info((Object)("ParameterMap -> Key: [" + key + "] Value Array [" + count + "]: [" + val + "]"));
                ++count;
            }
        }
    }
}

