/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import org.pf4j.BasePluginRepository;
import org.pf4j.util.AndFileFilter;
import org.pf4j.util.DirectoryFileFilter;
import org.pf4j.util.FileUtils;
import org.pf4j.util.HiddenFilter;
import org.pf4j.util.NameFileFilter;
import org.pf4j.util.NotFileFilter;
import org.pf4j.util.OrFileFilter;
import org.pf4j.util.ZipFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPluginRepository
extends BasePluginRepository {
    private static final Logger log = LoggerFactory.getLogger(DefaultPluginRepository.class);

    public DefaultPluginRepository(Path pluginsRoot, boolean development) {
        super(pluginsRoot);
        AndFileFilter pluginsFilter = new AndFileFilter(new DirectoryFileFilter());
        pluginsFilter.addFileFilter(new NotFileFilter(this.createHiddenPluginFilter(development)));
        this.setFilter(pluginsFilter);
    }

    @Override
    public List<Path> getPluginPaths() {
        File[] pluginZips = this.pluginsRoot.toFile().listFiles(new ZipFileFilter());
        if (pluginZips != null && pluginZips.length > 0) {
            for (File pluginZip : pluginZips) {
                try {
                    FileUtils.expandIfZip(pluginZip.toPath());
                }
                catch (IOException e) {
                    log.error("Cannot expand plugin zip '{}'", (Object)pluginZip);
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return super.getPluginPaths();
    }

    @Override
    public boolean deletePluginPath(Path pluginPath) {
        FileUtils.optimisticDelete(FileUtils.findWithEnding(pluginPath, ".zip", ".ZIP", ".Zip"));
        return super.deletePluginPath(pluginPath);
    }

    protected FileFilter createHiddenPluginFilter(boolean development) {
        OrFileFilter hiddenPluginFilter = new OrFileFilter(new HiddenFilter());
        if (development) {
            hiddenPluginFilter.addFileFilter(new NameFileFilter("target")).addFileFilter(new NameFileFilter("build"));
        }
        return hiddenPluginFilter;
    }
}

