package test.de.citunius.programab;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

import org.alicebot.ab.Bot;
import org.alicebot.ab.Chat;

/**
 * Synonyms Resolution
 * 
 * <p>Synonyms are words with similar meanings. A bot should reply in the same manner for similar words.</p>
 * 
 */
public class MainMyBot04_SynonymsResolution {

	/**
	 * Example dialogue:
	 * 
	    User: AGENT
		Bot:  Operator
		User: Worker
		Bot:  Operator
	 */
	public static void main(String[] args) {
		// If the Program AB bot files are in a directory <Project> then a bot named named mybot should use the directories:
		// | Directory | Contents | 
		// |:----------|:---------| 
		// | <Project>/resources/ab/bots/mybot04/aiml 	| AIML Files | 
		// | <Project>/bots/mybot04/aimlif 				| AIMLIF format files | 
		// | <Project>/bots/mybot04/config 				| Bot configuration Files | 
		// | <Project>/bots/mybot04/sets   				| AIML Sets | 
		// | <Project>/bots/mybot04/maps 				| AIML Maps |
		String botname="mybot04"; 
		String path=System.getProperty("user.dir") + "/resources/ab";
		String exitCommand = "bye";
		
		// Create a bot
		Bot bot = new Bot(botname, path); 
		// Create a client chat sessio
		Chat chatSession = new Chat(bot); 
		String request = null;
		
		System.out.println("--- THIS IS "+botname.toUpperCase()+" EXAMPLE (Test Case: Synonyms Resolution) ---");
		System.out.println("Bot:  Ask me something :-) (..or type '"+exitCommand+"' to end this conversation)");
		
		// Store all user requests to this list
		List<String> list = new ArrayList<String>();
		// Prepare scanner to read from console
		Scanner sn = new Scanner(System.in);
		// Loop until user wants to end this conversation
		while (true) {
			request = sn.nextLine();
			System.out.println("User: "+request);
			// Chat with the bot - Use the method multisentenceResponse to get the bot's replies to multiple-sentence (one or more sentence) inputs:
			String response = chatSession.multisentenceRespond(request); 
			System.out.println("Bot:  "+response);
		    list.add(request);
		    if (request != null && request.equals(exitCommand)) {
		    	sn.close();
		    	break;
		    }
		}
		System.out.println("-- Bot session end. --");
	}

}
