/*
 * Copyright: (c) 2015-2017, Citunius GmbH. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * Licence: This program contains proprietary and trade secret information of Citunius GmbH.
 *          Copyright notice is precautionary only and does not evidence any actual or intended 
 *          publication of such program
 *          See: https://www.citunius.de/en/legal
 *
 * Requires: JDK 1.8+
 *
 */
package de.citunius.businesslogic.helloprogramab.botbuilder;

import java.lang.invoke.MethodHandles;
import java.util.HashMap;

import org.apache.log4j.Logger;

import de.citunius.businesslogicapi.common.botbuilder.BotBuilderService;
import de.citunius.businesslogicapi.common.services.LocalisationService;

/**
 * BotBuilderService is the class represents the services for the Bot Builder Model.
 * This service calls the use case specific functions of this business bot plugin.
 * This class is called using Java reflections.
 *
 * @author me
 * @version %I%, %G%
 * @since   1.0
*/
public class BotBuilder implements BotBuilderService {
	static Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
	
	// Defines the syntax for function parameter field
	public static final String REQUIRED_PLUGINMAP_FUNCTION_PARAMS_FIELD = "REQUIRED_PLUGINMAP_FUNCTION_PARAMS_";
	
	/**
	 * Class constructor
	 * 
	 * @param pluginMap
	 * @param ls
	 * @param defaultLanguage
	 */
	public BotBuilder() {
		
	}
	
	/**
	 * Bot builder function for the dialogue designer
	 * 
	 * <p>This function returns just "Hello World" to the dialogue designer. 
	 * The result is return to the business bot platform for further processing</p>
	 * 
	 * @param pluginMap  the plugin hashmap
	 * @param ls  the language service instance
	 * @param defaultLanguage  the default user language
	 * @return  the result
	 */
	public String getHelloWorld(HashMap<String, String> pluginMap, LocalisationService ls, String defaultLanguage) {
		return "Hello World! I'm the Business Logic!";
	}
	
}
