package test.de.citunius.programab;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

import org.alicebot.ab.Bot;
import org.alicebot.ab.Chat;

/**
 * Symbolic Reduction
 * 
 * <p>The symbolic reduction technique is used to simplify patterns. It helps to reduce complex grammatical patterns with simple pattern(s).</p>
 *
 */
public class MainMyBot02_SymbolicReduction {

	/**
	 * Example dialogue:
	 * 
	    User: When can I reach the office?
		Bot:  The opening hours of the office are Monday to Friday from 9:00 am to 5:00 pm.
		User: Where is the company located?
		Bot:  The company is located at Kapuzinerstreet 50 in Mainz, Germany.
	 */
	public static void main(String[] args) {
		// If the Program AB bot files are in a directory <Project> then a bot named named mybot should use the directories:
		// | Directory | Contents | 
		// |:----------|:---------| 
		// | <Project>/resources/ab/bots/mybot02/aiml 	| AIML Files | 
		// | <Project>/bots/mybot02/aimlif 				| AIMLIF format files | 
		// | <Project>/bots/mybot02/config 				| Bot configuration Files | 
		// | <Project>/bots/mybot02/sets   				| AIML Sets | 
		// | <Project>/bots/mybot02/maps 				| AIML Maps |
		String botname="mybot02"; 
		String path=System.getProperty("user.dir") + "/resources/ab";
		String exitCommand = "bye";
		
		// Create a bot
		Bot bot = new Bot(botname, path); 
		// Create a client chat sessio
		Chat chatSession = new Chat(bot); 
		String request = null;
		
		System.out.println("--- THIS IS "+botname.toUpperCase()+" EXAMPLE (Test Case: Symbolic Reduction) ---");
		System.out.println("Bot:  Ask me something :-) (..or type '"+exitCommand+"' to end this conversation)");
		
		// Store all user requests to this list
		List<String> list = new ArrayList<String>();
		// Prepare scanner to read from console
		Scanner sn = new Scanner(System.in);
		// Loop until user wants to end this conversation
		while (true) {
			request = sn.nextLine();
			System.out.println("User: "+request);
			// Chat with the bot - Use the method multisentenceResponse to get the bot's replies to multiple-sentence (one or more sentence) inputs:
			String response = chatSession.multisentenceRespond(request); 
			System.out.println("Bot:  "+response);
		    list.add(request);
		    if (request != null && request.equals(exitCommand)) {
		    	sn.close();
		    	break;
		    }
		}
		System.out.println("-- Bot session end. --");	
	}

}
