package test.de.citunius.programab;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

import org.alicebot.ab.Bot;
import org.alicebot.ab.Chat;

/**
 * Topic Tag
 * 
 * <p>The <topic> Tag is used in AIML to store a context so that later 
 * conversation can be done based on that context. Usually, <topic> tag 
 * is used in Yes/No type conversation. It helps AIML to search categories 
 * written within the context of the topic.</p>
 *
 */
public class MainMyBot09_TopicTag {

	/**
	 * Example dialogue:
	 * 
	    User: let discuss movies
		Bot:  Yes movies
		User: Comedy movies are nice to watch
		Bot:  Watching good movie refreshes our minds.
		User: I like watching comedy
		Bot:  I too like watching comedy.
	 */
	public static void main(String[] args) {
		// If the Program AB bot files are in a directory <Project> then a bot named named mybot should use the directories:
		// | Directory | Contents | 
		// |:----------|:---------| 
		// | <Project>/resources/ab/bots/mybot09/aiml 	| AIML Files | 
		// | <Project>/bots/mybot09/aimlif 				| AIMLIF format files | 
		// | <Project>/bots/mybot09/config 				| Bot configuration Files | 
		// | <Project>/bots/mybot09/sets   				| AIML Sets | 
		// | <Project>/bots/mybot09/maps 				| AIML Maps |
		String botname="mybot09"; 
		String path=System.getProperty("user.dir") + "/resources/ab";
		String exitCommand = "bye";
		
		// Create a bot
		Bot bot = new Bot(botname, path); 
		// Create a client chat sessio
		Chat chatSession = new Chat(bot); 
		String request = null;
		
		System.out.println("--- THIS IS "+botname.toUpperCase()+" EXAMPLE (Test Case: <Topic> Tag) ---");
		System.out.println("Bot:  Ask me something :-) (..or type '"+exitCommand+"' to end this conversation)");
		
		// Store all user requests to this list
		List<String> list = new ArrayList<String>();
		// Prepare scanner to read from console
		Scanner sn = new Scanner(System.in);
		// Loop until user wants to end this conversation
		while (true) {
			request = sn.nextLine();
			System.out.println("User: "+request);
			// Chat with the bot - Use the method multisentenceResponse to get the bot's replies to multiple-sentence (one or more sentence) inputs:
			String response = chatSession.multisentenceRespond(request); 
			System.out.println("Bot:  "+response);
		    list.add(request);
		    if (request != null && request.equals(exitCommand)) {
		    	sn.close();
		    	break;
		    }
		}
		System.out.println("-- Bot session end. --");
	}

}
