package test.de.citunius.programab;

import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

import org.alicebot.ab.Bot;
import org.alicebot.ab.Chat;

/**
 * Think Tag
 * 
 * <p>The <think> Tag is used in AIML to store 
 * a variable without notifying the user./p>
 *
 */
public class MainMyBot10_ThinkTag {

	/**
	 * Example dialogue:
	 * 
	    User: My name is Max
		Bot:  Hello!
		User: Byeee
		Bot:  Hi Max. Thanks for the conversation!
	 */
	public static void main(String[] args) {
		// If the Program AB bot files are in a directory <Project> then a bot named named mybot should use the directories:
		// | Directory | Contents | 
		// |:----------|:---------| 
		// | <Project>/resources/ab/bots/mybot10/aiml 	| AIML Files | 
		// | <Project>/bots/mybot10/aimlif 				| AIMLIF format files | 
		// | <Project>/bots/mybot10/config 				| Bot configuration Files | 
		// | <Project>/bots/mybot10/sets   				| AIML Sets | 
		// | <Project>/bots/mybot10/maps 				| AIML Maps |
		String botname="mybot10"; 
		String path=System.getProperty("user.dir") + "/resources/ab";
		String exitCommand = "bye";
		
		// Create a bot
		Bot bot = new Bot(botname, path); 
		// Create a client chat sessio
		Chat chatSession = new Chat(bot); 
		String request = null;
		
		System.out.println("--- THIS IS "+botname.toUpperCase()+" EXAMPLE (Test Case: <Think> Tag) ---");
		System.out.println("Bot:  Ask me something :-) (..or type '"+exitCommand+"' to end this conversation)");
		
		// Store all user requests to this list
		List<String> list = new ArrayList<String>();
		// Prepare scanner to read from console
		Scanner sn = new Scanner(System.in);
		// Loop until user wants to end this conversation
		while (true) {
			request = sn.nextLine();
			System.out.println("User: "+request);
			// Chat with the bot - Use the method multisentenceResponse to get the bot's replies to multiple-sentence (one or more sentence) inputs:
			String response = chatSession.multisentenceRespond(request); 
			System.out.println("Bot:  "+response);
		    list.add(request);
		    if (request != null && request.equals(exitCommand)) {
		    	sn.close();
		    	break;
		    }
		}
		System.out.println("-- Bot session end. --");	
	}

}
