/*
 * Decompiled with CFR 0.152.
 */
package org.pf4j.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.pf4j.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Unzip {
    private static final Logger log = LoggerFactory.getLogger(Unzip.class);
    private File destination;
    private File source;

    public Unzip() {
    }

    public Unzip(File source, File destination) {
        this.source = source;
        this.destination = destination;
    }

    public void setSource(File source) {
        this.source = source;
    }

    public void setDestination(File destination) {
        this.destination = destination;
    }

    public void extract() throws IOException {
        block29: {
            log.debug("Extract content of '{}' to '{}'", (Object)this.source, (Object)this.destination);
            if (this.destination.exists() && this.destination.isDirectory()) {
                FileUtils.delete(this.destination.toPath());
            }
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(this.source));
            Throwable throwable = null;
            block20: while (true) {
                try {
                    ZipEntry zipEntry;
                    while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                        try {
                            File file = new File(this.destination, zipEntry.getName());
                            File dir = new File(file.getParent());
                            dir.mkdirs();
                            if (zipEntry.isDirectory()) {
                                file.mkdirs();
                                continue block20;
                            }
                            byte[] buffer = new byte[1024];
                            FileOutputStream fos = new FileOutputStream(file);
                            Throwable throwable2 = null;
                            try {
                                while (true) {
                                    int length;
                                    if ((length = zipInputStream.read(buffer)) < 0) continue block20;
                                    fos.write(buffer, 0, length);
                                }
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (fos == null) continue block20;
                                if (throwable2 != null) {
                                    try {
                                        fos.close();
                                    }
                                    catch (Throwable x2) {
                                        throwable2.addSuppressed(x2);
                                    }
                                    continue block20;
                                }
                                fos.close();
                                continue block20;
                            }
                        }
                        catch (FileNotFoundException e) {
                            log.error("File '{}' not found", (Object)zipEntry.getName());
                        }
                    }
                    break block29;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            finally {
                if (zipInputStream != null) {
                    if (throwable != null) {
                        try {
                            zipInputStream.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                    } else {
                        zipInputStream.close();
                    }
                }
            }
        }
    }
}

