/*
 * Decompiled with CFR 0.152.
 */
package com.rivescript.parser;

import com.rivescript.ConcatMode;
import com.rivescript.Config;
import com.rivescript.ast.ObjectMacro;
import com.rivescript.ast.Root;
import com.rivescript.ast.Trigger;
import com.rivescript.parser.ParserConfig;
import com.rivescript.parser.ParserException;
import com.rivescript.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parser {
    public static final double RS_VERSION = 2.0;
    private static Logger logger = LoggerFactory.getLogger(Parser.class);
    private boolean strict;
    private boolean utf8;
    private boolean forceCase;
    private ConcatMode concat;

    public Parser() {
        this(null);
    }

    public Parser(ParserConfig config) {
        if (config == null) {
            config = new ParserConfig();
        }
        this.strict = config.isStrict();
        this.utf8 = config.isUtf8();
        this.forceCase = config.isForceCase();
        this.concat = config.getConcat();
    }

    public Root parse(String filename, String[] code) throws ParserException {
        logger.debug("Parsing {}", (Object)filename);
        if (logger.isTraceEnabled()) {
            for (String line : code) {
                logger.trace("{}", (Object)line);
            }
        }
        long startTime = System.currentTimeMillis();
        Root ast = new Root();
        String topic = "random";
        int lineno = 0;
        boolean inComment = false;
        boolean inObject = false;
        String objectName = null;
        String objectLanguage = null;
        ArrayList<String> objectBuffer = null;
        Trigger currentTrigger = null;
        String previous = null;
        HashMap<String, String> localOptions = new HashMap<String, String>();
        block43: for (int lp = 0; lp < code.length; ++lp) {
            lineno = lp + 1;
            String line = code[lp].trim();
            if (line.length() == 0) continue;
            if (inObject) {
                if (line.contains("< object") || line.contains("<object")) {
                    if (objectName != null && objectName.length() > 0) {
                        ObjectMacro object = new ObjectMacro();
                        object.setName(objectName);
                        object.setLanguage(objectLanguage);
                        object.setCode((List<String>)objectBuffer);
                        ast.addObject(object);
                    }
                    inObject = false;
                    objectName = null;
                    objectLanguage = null;
                    objectBuffer = null;
                    continue;
                }
                objectBuffer.add(line);
                continue;
            }
            if (line.startsWith("//")) continue;
            if (line.startsWith("/*")) {
                if (line.contains("*/")) continue;
                inComment = true;
                continue;
            }
            if (line.contains("*/")) {
                inComment = false;
                continue;
            }
            if (inComment) continue;
            if (line.length() < 2) {
                logger.warn("Weird single-character line '{}' at {} line {}", new Object[]{line, filename, lineno});
                continue;
            }
            String cmd = line.substring(0, 1);
            if ((line = line.substring(1)).contains(" // ")) {
                line = line.substring(0, line.indexOf(" // "));
            }
            line = line.trim();
            if (this.forceCase && cmd.equals("+")) {
                line = line.toLowerCase();
            }
            logger.debug("Cmd: {}; line: {}", (Object)cmd, (Object)line);
            try {
                this.checkSyntax(cmd, line);
            }
            catch (ParserException e) {
                if (this.strict) {
                    throw e;
                }
                logger.warn("Syntax error '{}' at {} line {}", new Object[]{e.getMessage(), filename, lineno});
            }
            if (cmd.equals("+")) {
                previous = null;
            }
            if (!cmd.equals("^")) {
                for (int li = lp + 1; li < code.length; ++li) {
                    String lookahead = code[li].trim();
                    if (lookahead.length() < 2) continue;
                    String lookCmd = lookahead.substring(0, 1);
                    lookahead = lookahead.substring(1).trim();
                    if (!lookCmd.equals("%") && !lookCmd.equals("^") || lookahead.length() == 0) break;
                    logger.debug("\tLookahead {}: {} {}", new Object[]{li, lookCmd, lookahead});
                    if (cmd.equals("+")) {
                        if (lookCmd.equals("%")) {
                            previous = lookahead;
                            break;
                        }
                        previous = null;
                    }
                    if (cmd.equals("!")) {
                        if (!lookCmd.equals("^")) continue;
                        line = line + "<crlf>" + lookahead;
                        continue;
                    }
                    if (cmd.equals("^") || lookCmd.equals("%") || !lookCmd.equals("^")) continue;
                    ConcatMode concat = null;
                    if (localOptions.containsKey("concat")) {
                        concat = ConcatMode.fromName((String)localOptions.get("concat"));
                    }
                    if (concat == null) {
                        concat = this.concat != null ? this.concat : Config.DEFAULT_CONCAT;
                    }
                    line = line + concat.getConcatChar() + lookahead;
                }
            }
            switch (cmd) {
                case "!": {
                    String[] halves = line.split("=", 2);
                    String[] left = halves[0].trim().split(" ", 2);
                    String value = "";
                    String kind = "";
                    String name = "";
                    if (halves.length == 2) {
                        value = halves[1].trim();
                    }
                    if (left.length >= 1) {
                        kind = left[0].trim();
                        if (left.length >= 2) {
                            left = Arrays.copyOfRange(left, 1, left.length);
                            name = StringUtils.join(left, " ").trim();
                        }
                    }
                    if (!kind.equals("array")) {
                        value = value.replaceAll("<crlf>", "");
                    }
                    if (kind.equals("version")) {
                        double parsedVersion = 0.0;
                        try {
                            parsedVersion = Double.parseDouble(value);
                        }
                        catch (NumberFormatException e) {
                            logger.warn("RiveScript version '{}' at {} line {} is not a valid floating number", new Object[]{value, filename, lineno});
                        }
                        if (!(parsedVersion > 2.0)) continue block43;
                        throw new ParserException(String.format("Unsupported RiveScript version at %s line %d. We only support %s", filename, lineno, 2.0));
                    }
                    if (name.length() == 0) {
                        logger.warn("Undefined variable name at {} line {}", (Object)filename, (Object)lineno);
                        continue block43;
                    }
                    if (value.length() == 0) {
                        logger.warn("Undefined variable value at {} line {}", (Object)filename, (Object)lineno);
                        continue block43;
                    }
                    switch (kind) {
                        case "local": {
                            logger.debug("\tSet local parser option {} = {}", (Object)name, (Object)value);
                            localOptions.put(name, value);
                            continue block43;
                        }
                        case "global": {
                            logger.debug("\tSet global {} = {}", (Object)name, (Object)value);
                            ast.getBegin().addGlobal(name, value);
                            continue block43;
                        }
                        case "var": {
                            logger.debug("\tSet bot variable {} = {}", (Object)name, (Object)value);
                            ast.getBegin().addVar(name, value);
                            continue block43;
                        }
                        case "array": {
                            logger.debug("\tSet array {} = {}", (Object)name, (Object)value);
                            String[] parts = value.split("<crlf>");
                            ArrayList<String> fields = new ArrayList<String>();
                            for (String val : parts) {
                                if (val.contains("|")) {
                                    fields.addAll(Arrays.asList(val.split("\\|")));
                                    continue;
                                }
                                fields.addAll(Arrays.asList(val.split("\\s+")));
                            }
                            for (int i = 0; i < fields.size(); ++i) {
                                fields.set(i, ((String)fields.get(i)).replaceAll("\\\\s", " "));
                            }
                            ast.getBegin().addArray(name, fields);
                            continue block43;
                        }
                        case "sub": {
                            logger.debug("\tSet substitution {} = {}", (Object)name, (Object)value);
                            ast.getBegin().addSub(name, value);
                            continue block43;
                        }
                        case "person": {
                            logger.debug("\tSet person substitution {} = {}", (Object)name, (Object)value);
                            ast.getBegin().addPerson(name, value);
                            continue block43;
                        }
                    }
                    logger.warn("Unknown definition type '{}' found at {} line {}", new Object[]{kind, filename, lineno});
                    continue block43;
                }
                case ">": {
                    String[] temp = line.trim().split(" ");
                    String kind = temp[0];
                    temp = Arrays.copyOfRange(temp, 1, temp.length);
                    String name = "";
                    String[] fields = new String[]{};
                    if (temp.length > 0) {
                        name = temp[0];
                        temp = Arrays.copyOfRange(temp, 1, temp.length);
                    }
                    if (temp.length > 0) {
                        fields = temp;
                    }
                    if (kind.equals("begin")) {
                        logger.debug("Found the BEGIN block at {} line {}", (Object)filename, (Object)lineno);
                        kind = "topic";
                        name = "__begin__";
                    }
                    if (kind.equals("topic")) {
                        if (this.forceCase) {
                            name = name.toLowerCase();
                        }
                        logger.debug("Set topic to {}", (Object)name);
                        currentTrigger = null;
                        topic = name;
                        ast.addTopic(topic);
                        String mode = "";
                        if (fields.length < 2) continue block43;
                        for (String field : fields) {
                            if (field.equals("includes") || field.equals("inherits")) {
                                mode = field;
                                continue;
                            }
                            if (mode.equals("includes")) {
                                ast.getTopic(topic).addInclude(field, true);
                                continue;
                            }
                            if (!mode.equals("inherits")) continue;
                            ast.getTopic(topic).addInherit(field, true);
                        }
                        continue block43;
                    }
                    if (kind.equals("object")) {
                        String language = "";
                        if (fields.length > 0) {
                            language = fields[0].toLowerCase();
                        }
                        objectName = name;
                        objectLanguage = language;
                        objectBuffer = new ArrayList<String>();
                        inObject = true;
                        if (!language.equals("")) continue block43;
                        logger.warn("No programming language specified for object '{}' at {} line", new Object[]{name, filename, lineno});
                        objectLanguage = "__unknown__";
                        continue block43;
                    }
                    logger.warn("Unknown label type '{}' at {} line {}", new Object[]{kind, filename, lineno});
                    continue block43;
                }
                case "<": {
                    String kind = line;
                    if (kind.equals("begin") || kind.equals("topic")) {
                        logger.debug("\tEnd the topic label.");
                        topic = "random";
                        continue block43;
                    }
                    if (kind.equals("object")) {
                        logger.debug("\tEnd the object label.");
                        inObject = false;
                        continue block43;
                    }
                    logger.warn("Unknown end topic type '{}' at {} line {}", new Object[]{kind, filename, lineno});
                    continue block43;
                }
                case "+": {
                    logger.debug("\tTrigger pattern: {}", (Object)line);
                    currentTrigger = new Trigger();
                    currentTrigger.setTrigger(line);
                    currentTrigger.setPrevious(previous);
                    ast.getTopic(topic).addTrigger(currentTrigger);
                    continue block43;
                }
                case "-": {
                    if (currentTrigger == null) {
                        logger.warn("Response found before trigger at {} line {}", (Object)filename, (Object)lineno);
                        continue block43;
                    }
                    if (currentTrigger.getRedirect() != null) {
                        logger.warn("You can't mix @Redirects with -Replies at {} line {}", (Object)filename, (Object)lineno);
                    }
                    logger.debug("\tResponse: {}", (Object)line);
                    currentTrigger.addReply(line);
                    continue block43;
                }
                case "*": {
                    if (currentTrigger == null) {
                        logger.warn("Condition found before trigger at {} line {}", (Object)filename, (Object)lineno);
                        continue block43;
                    }
                    logger.debug("\tCondition: {}", (Object)line);
                    currentTrigger.addCondition(line);
                    continue block43;
                }
                case "%": {
                    continue block43;
                }
                case "^": {
                    continue block43;
                }
                case "@": {
                    if (currentTrigger == null) {
                        logger.warn("Redirect found before trigger at {} line {}", (Object)filename, (Object)lineno);
                        continue block43;
                    }
                    logger.debug("\tRedirect response to: {}", (Object)line);
                    currentTrigger.setRedirect(line);
                    continue block43;
                }
                default: {
                    logger.warn("Unknown command '{}' found at {} line {}", new Object[]{cmd, filename, lineno});
                }
            }
        }
        if (logger.isDebugEnabled()) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            logger.debug("Parsing {} completed in {} ms", (Object)filename, (Object)elapsedTime);
        }
        return ast;
    }

    private void checkSyntax(String cmd, String line) throws ParserException {
        if (cmd.equals("!")) {
            if (!line.matches("^(version|local|global|var|array|sub|person)(?:\\s+.+|)\\s*=\\s*.+?$")) {
                throw new ParserException("Invalid format for !Definition line: must be '! type name = value' OR '! type = value'");
            }
            if (line.matches("^array")) {
                if (line.matches("\\=\\s?\\||\\|\\s?$")) {
                    throw new ParserException("Piped arrays can't begin or end with a |");
                }
                if (line.matches("\\|\\|")) {
                    throw new ParserException("Piped arrays can't include blank entries");
                }
            }
        } else if (cmd.equals(">")) {
            String[] parts = line.split("\\s+");
            if (parts[0].equals("begin") && parts.length > 1) {
                throw new ParserException("The 'begin' label takes no additional arguments");
            }
            if (parts[0].equals("topic")) {
                if (!this.forceCase && line.matches("[^a-z0-9_\\-\\s]")) {
                    throw new ParserException("Topics should be lowercased and contain only letters and numbers");
                }
                if (line.matches("[^A-Za-z0-9_\\-\\s]")) {
                    throw new ParserException("Topics should contain only letters and numbers in forceCase mode");
                }
            } else if (parts[0].equals("object") && line.matches("[^A-Za-z0-9\\_\\-\\s]")) {
                throw new ParserException("Objects can only contain numbers and letters");
            }
        } else if (cmd.equals("+") || cmd.equals("%") || cmd.equals("@")) {
            int parens = 0;
            int square = 0;
            int curly = 0;
            int angle = 0;
            if (this.utf8) {
                if (line.matches("[A-Z\\\\.]")) {
                    throw new ParserException("Triggers can't contain uppercase letters, backslashes or dots in UTF-8 mode");
                }
            } else {
                if (line.matches("[^a-z0-9(|)\\[\\]*_#@{}<>=\\/\\s]")) {
                    throw new ParserException("Triggers may only contain lowercase letters, numbers, and these symbols: ( | ) [ ] * _ # { } < > = /");
                }
                if (line.matches("\\(\\||\\|\\)")) {
                    throw new ParserException("Piped alternations can't begin or end with a |");
                }
                if (line.matches("\\([^\\)].+\\|\\|.+\\)")) {
                    throw new ParserException("Piped alternations can't include blank entries");
                }
                if (line.matches("\\[\\||\\|\\]")) {
                    throw new ParserException("Piped optionals can't begin or end with a |");
                }
                if (line.matches("\\[[^\\]].+\\|\\|.+\\]")) {
                    throw new ParserException("Piped optionals can't include blank entries");
                }
            }
            block10: for (char c : line.toCharArray()) {
                switch (c) {
                    case '(': {
                        ++parens;
                        continue block10;
                    }
                    case ')': {
                        --parens;
                        continue block10;
                    }
                    case '[': {
                        ++square;
                        continue block10;
                    }
                    case ']': {
                        --square;
                        continue block10;
                    }
                    case '{': {
                        ++curly;
                        continue block10;
                    }
                    case '}': {
                        --curly;
                        continue block10;
                    }
                    case '<': {
                        ++angle;
                        continue block10;
                    }
                    case '>': {
                        --angle;
                    }
                }
            }
            if (parens != 0) {
                throw new ParserException("Unmatched parenthesis brackets");
            }
            if (square != 0) {
                throw new ParserException("Unmatched square brackets");
            }
            if (curly != 0) {
                throw new ParserException("Unmatched curly brackets");
            }
            if (angle != 0) {
                throw new ParserException("Unmatched angle brackets");
            }
        } else if (cmd.equals("*") && !line.matches("^.+?\\s*(?:==|eq|!=|ne|<>|<|<=|>|>=)\\s*.+?=>.+?$")) {
            throw new ParserException("Invalid format for !Condition: should be like '* value symbol value => response'");
        }
    }
}

