/*
 * Decompiled with CFR 0.152.
 */
package com.rivescript;

import com.rivescript.ConcatMode;
import com.rivescript.Config;
import com.rivescript.RiveScriptException;
import com.rivescript.ast.ObjectMacro;
import com.rivescript.ast.Root;
import com.rivescript.ast.Topic;
import com.rivescript.ast.Trigger;
import com.rivescript.exception.DeepRecursionException;
import com.rivescript.exception.NoDefaultTopicException;
import com.rivescript.exception.RepliesNotSortedException;
import com.rivescript.exception.ReplyNotFoundException;
import com.rivescript.exception.ReplyNotMatchedException;
import com.rivescript.macro.ObjectHandler;
import com.rivescript.macro.Subroutine;
import com.rivescript.parser.Parser;
import com.rivescript.parser.ParserConfig;
import com.rivescript.parser.ParserException;
import com.rivescript.regexp.Regexp;
import com.rivescript.session.ConcurrentHashMapSessionManager;
import com.rivescript.session.History;
import com.rivescript.session.SessionManager;
import com.rivescript.session.ThawAction;
import com.rivescript.session.UserData;
import com.rivescript.sorting.SortBuffer;
import com.rivescript.sorting.SortTrack;
import com.rivescript.sorting.SortedTriggerEntry;
import com.rivescript.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RiveScript {
    public static final String DEEP_RECURSION_KEY = "deepRecursion";
    public static final String REPLIES_NOT_SORTED_KEY = "repliesNotSorted";
    public static final String DEFAULT_TOPIC_NOT_FOUND_KEY = "defaultTopicNotFound";
    public static final String REPLY_NOT_MATCHED_KEY = "replyNotMatched";
    public static final String REPLY_NOT_FOUND_KEY = "replyNotFound";
    public static final String OBJECT_NOT_FOUND_KEY = "objectNotFound";
    public static final String CANNOT_DIVIDE_BY_ZERO_KEY = "cannotDivideByZero";
    public static final String CANNOT_MATH_VARIABLE_KEY = "cannotMathVariable";
    public static final String CANNOT_MATH_VALUE_KEY = "cannotMathValue";
    public static final String DEFAULT_DEEP_RECURSION_MESSAGE = "ERR: Deep Recursion Detected";
    public static final String DEFAULT_REPLIES_NOT_SORTED_MESSAGE = "ERR: Replies Not Sorted";
    public static final String DEFAULT_DEFAULT_TOPIC_NOT_FOUND_MESSAGE = "ERR: No default topic 'random' was found";
    public static final String DEFAULT_REPLY_NOT_MATCHED_MESSAGE = "ERR: No Reply Matched";
    public static final String DEFAULT_REPLY_NOT_FOUND_MESSAGE = "ERR: No Reply Found";
    public static final String DEFAULT_OBJECT_NOT_FOUND_MESSAGE = "[ERR: Object Not Found]";
    public static final String DEFAULT_CANNOT_DIVIDE_BY_ZERO_MESSAGE = "[ERR: Can't Divide By Zero]";
    public static final String DEFAULT_CANNOT_MATH_VARIABLE_MESSAGE = "[ERR: Can't perform math operation on non-numeric variable]";
    public static final String DEFAULT_CANNOT_MATH_VALUE_MESSAGE = "[ERR: Can't perform math operation on non-numeric value]";
    public static final String UNDEFINED = "undefined";
    public static final String[] DEFAULT_FILE_EXTENSIONS = new String[]{".rive", ".rs"};
    private static final Random RANDOM = new Random();
    private static final String UNDEF_TAG = "<undef>";
    private static Logger logger = LoggerFactory.getLogger(RiveScript.class);
    private boolean throwExceptions;
    private boolean strict;
    private boolean utf8;
    private boolean forceCase;
    private ConcatMode concat;
    private int depth;
    private Pattern unicodePunctuation;
    private Map<String, String> errorMessages;
    private Parser parser;
    private Map<String, String> global;
    private Map<String, String> vars;
    private Map<String, String> sub;
    private Map<String, String> person;
    private Map<String, List<String>> array;
    private SessionManager sessions;
    private Map<String, Map<String, Boolean>> includes;
    private Map<String, Map<String, Boolean>> inherits;
    private Map<String, String> objectLanguages;
    private Map<String, ObjectHandler> handlers;
    private Map<String, Subroutine> subroutines;
    private Map<String, Topic> topics;
    private SortBuffer sorted;
    private ThreadLocal<String> currentUser = new ThreadLocal();

    public RiveScript() {
        this(null);
    }

    public RiveScript(Config config) {
        if (config == null) {
            config = Config.basic();
        }
        this.throwExceptions = config.isThrowExceptions();
        this.strict = config.isStrict();
        this.utf8 = config.isUtf8();
        this.forceCase = config.isForceCase();
        this.concat = config.getConcat();
        this.depth = config.getDepth();
        this.sessions = config.getSessionManager();
        String unicodePunctuation = config.getUnicodePunctuation();
        if (unicodePunctuation == null) {
            unicodePunctuation = "[.,!?;:]";
        }
        this.unicodePunctuation = Pattern.compile(unicodePunctuation);
        this.errorMessages = new HashMap<String, String>();
        this.errorMessages.put(DEEP_RECURSION_KEY, DEFAULT_DEEP_RECURSION_MESSAGE);
        this.errorMessages.put(REPLIES_NOT_SORTED_KEY, DEFAULT_REPLIES_NOT_SORTED_MESSAGE);
        this.errorMessages.put(DEFAULT_TOPIC_NOT_FOUND_KEY, DEFAULT_DEFAULT_TOPIC_NOT_FOUND_MESSAGE);
        this.errorMessages.put(REPLY_NOT_MATCHED_KEY, DEFAULT_REPLY_NOT_MATCHED_MESSAGE);
        this.errorMessages.put(REPLY_NOT_FOUND_KEY, DEFAULT_REPLY_NOT_FOUND_MESSAGE);
        this.errorMessages.put(OBJECT_NOT_FOUND_KEY, DEFAULT_OBJECT_NOT_FOUND_MESSAGE);
        this.errorMessages.put(CANNOT_DIVIDE_BY_ZERO_KEY, DEFAULT_CANNOT_DIVIDE_BY_ZERO_MESSAGE);
        this.errorMessages.put(CANNOT_MATH_VARIABLE_KEY, DEFAULT_CANNOT_MATH_VARIABLE_MESSAGE);
        this.errorMessages.put(CANNOT_MATH_VALUE_KEY, DEFAULT_CANNOT_MATH_VALUE_MESSAGE);
        if (config.getErrorMessages() != null) {
            for (Map.Entry<String, String> entry : config.getErrorMessages().entrySet()) {
                this.errorMessages.put(entry.getKey(), entry.getValue());
            }
        }
        if (this.concat == null) {
            this.concat = Config.DEFAULT_CONCAT;
            logger.debug("No concat config: using default {}", (Object)Config.DEFAULT_CONCAT);
        }
        if (this.depth <= 0) {
            this.depth = 50;
            logger.debug("No depth config: using default {}", (Object)50);
        }
        if (this.sessions == null) {
            this.sessions = new ConcurrentHashMapSessionManager();
            logger.debug("No SessionManager config: using default ConcurrentHashMapSessionManager");
        }
        this.parser = new Parser(ParserConfig.newBuilder().strict(this.strict).utf8(this.utf8).forceCase(this.forceCase).concat(this.concat).build());
        this.global = new HashMap<String, String>();
        this.vars = new HashMap<String, String>();
        this.sub = new HashMap<String, String>();
        this.person = new HashMap<String, String>();
        this.array = new HashMap<String, List<String>>();
        this.includes = new HashMap<String, Map<String, Boolean>>();
        this.inherits = new HashMap<String, Map<String, Boolean>>();
        this.objectLanguages = new HashMap<String, String>();
        this.handlers = new HashMap<String, ObjectHandler>();
        this.subroutines = new HashMap<String, Subroutine>();
        this.topics = new HashMap<String, Topic>();
        this.sorted = new SortBuffer();
    }

    public static String getVersion() {
        Package pkg = RiveScript.class.getPackage();
        return pkg != null ? pkg.getImplementationVersion() : null;
    }

    public boolean isThrowExceptions() {
        return this.throwExceptions;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isUtf8() {
        return this.utf8;
    }

    public boolean isForceCase() {
        return this.forceCase;
    }

    public ConcatMode getConcat() {
        return this.concat;
    }

    public int getDepth() {
        return this.depth;
    }

    public String getUnicodePunctuation() {
        return this.unicodePunctuation != null ? this.unicodePunctuation.toString() : null;
    }

    public Map<String, String> getErrorMessages() {
        return Collections.unmodifiableMap(this.errorMessages);
    }

    public void setHandler(String name, ObjectHandler handler) {
        this.handlers.put(name, handler);
    }

    public void removeHandler(String name) {
        Iterator<Map.Entry<String, String>> it = this.objectLanguages.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            if (!entry.getValue().equals(name)) continue;
            it.remove();
        }
        this.handlers.remove(name);
    }

    public Map<String, ObjectHandler> getHandlers() {
        return Collections.unmodifiableMap(this.handlers);
    }

    public void setSubroutine(String name, Subroutine subroutine) {
        this.subroutines.put(name, subroutine);
    }

    public void removeSubroutine(String name) {
        this.subroutines.remove(name);
    }

    public Map<String, Subroutine> getSubroutines() {
        return Collections.unmodifiableMap(this.subroutines);
    }

    public void setGlobal(String name, String value) {
        if (value == null) {
            this.global.remove(name);
        } else if (name.equals("depth")) {
            try {
                this.depth = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                logger.warn("Can't set global 'depth' to '{}': {}", (Object)value, (Object)e.getMessage());
            }
        } else {
            this.global.put(name, value);
        }
    }

    public String getGlobal(String name) {
        if (name != null && name.equals("depth")) {
            return Integer.toString(this.depth);
        }
        return this.global.get(name);
    }

    public void setVariable(String name, String value) {
        if (value == null) {
            this.vars.remove(name);
        } else {
            this.vars.put(name, value);
        }
    }

    public String getVariable(String name) {
        return this.vars.get(name);
    }

    public Map<String, String> getVariables() {
        return this.vars;
    }

    public void setSubstitution(String name, String value) {
        if (value == null) {
            this.sub.remove(name);
        } else {
            this.sub.put(name, value);
        }
    }

    public String getSubstitution(String name) {
        return this.sub.get(name);
    }

    public void setPerson(String name, String value) {
        if (value == null) {
            this.person.remove(name);
        } else {
            this.person.put(name, value);
        }
    }

    public String getPerson(String name) {
        return this.person.get(name);
    }

    private boolean checkDeepRecursion(int depth, String message) throws DeepRecursionException {
        if (depth > this.depth) {
            logger.warn(message);
            if (this.throwExceptions) {
                throw new DeepRecursionException(message);
            }
            return true;
        }
        return false;
    }

    public void loadInputStream(InputStream inputStream) {
        Objects.requireNonNull(inputStream, "'inputStream' must not be null");
        this.loadReader(inputStream.toString(), new InputStreamReader(inputStream, this.isUtf8() ? StandardCharsets.UTF_8 : Charset.defaultCharset()));
    }

    protected void loadReader(String name, Reader reader) throws RiveScriptException, ParserException {
        ArrayList<String> code = new ArrayList<String>();
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                code.add(line);
            }
            this.parse(name, code.toArray(new String[0]));
        }
        catch (IOException e) {
            throw new RiveScriptException("Error reading resource '" + name + "'", e);
        }
    }

    public void loadFile(File file) throws RiveScriptException, ParserException {
        Objects.requireNonNull(file, "'file' must not be null");
        logger.debug("Loading RiveScript file: {}", (Object)file);
        if (!file.exists()) {
            throw new RiveScriptException("File '" + file + "' not found");
        }
        if (!file.isFile()) {
            throw new RiveScriptException("File '" + file + "' is not a regular file");
        }
        if (!file.canRead()) {
            throw new RiveScriptException("File '" + file + "' cannot be read");
        }
        try {
            this.loadReader(file.toString(), new FileReader(file));
        }
        catch (IOException e) {
            throw new RiveScriptException("Error reading file '" + file + "'", e);
        }
    }

    public void loadFile(String path) throws RiveScriptException, ParserException {
        Objects.requireNonNull(path, "'path' must not be null");
        this.loadFile(new File(path));
    }

    public void loadDirectory(File directory, String ... extensions) throws RiveScriptException, ParserException {
        Objects.requireNonNull(directory, "'directory' must not be null");
        logger.debug("Loading RiveScript files from directory: {}", (Object)directory);
        if (extensions.length == 0) {
            extensions = DEFAULT_FILE_EXTENSIONS;
        }
        final String[] exts = extensions;
        if (!directory.exists()) {
            throw new RiveScriptException("Directory '" + directory + "' not found");
        }
        if (!directory.isDirectory()) {
            throw new RiveScriptException("Directory '" + directory + "' is not a directory");
        }
        File[] files = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                for (String ext : exts) {
                    if (!name.endsWith(ext)) continue;
                    return true;
                }
                return false;
            }
        });
        if (files.length == 0) {
            logger.warn("No files found in directory: {}", (Object)directory);
        }
        for (File file : files) {
            this.loadFile(file);
        }
    }

    public void loadDirectory(String path, String ... extensions) throws RiveScriptException, ParserException {
        Objects.requireNonNull(path, "'path' must not be null");
        this.loadDirectory(new File(path), extensions);
    }

    public void stream(String code) throws ParserException {
        String[] lines = code.split("\n");
        this.stream(lines);
    }

    public void stream(String[] code) throws ParserException {
        this.parse("stream()", code);
    }

    private void parse(String filename, String[] code) throws ParserException {
        Root ast = this.parser.parse(filename, code);
        for (Map.Entry<String, String> entry : ast.getBegin().getGlobal().entrySet()) {
            if (entry.getValue().equals(UNDEF_TAG)) {
                this.global.remove(entry.getKey());
                continue;
            }
            this.global.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : ast.getBegin().getVar().entrySet()) {
            if (entry.getValue().equals(UNDEF_TAG)) {
                this.vars.remove(entry.getKey());
                continue;
            }
            this.vars.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : ast.getBegin().getSub().entrySet()) {
            if (entry.getValue().equals(UNDEF_TAG)) {
                this.sub.remove(entry.getKey());
                continue;
            }
            this.sub.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, String> entry : ast.getBegin().getPerson().entrySet()) {
            if (entry.getValue().equals(UNDEF_TAG)) {
                this.person.remove(entry.getKey());
                continue;
            }
            this.person.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, Object> entry : ast.getBegin().getArray().entrySet()) {
            if (((List)entry.getValue()).equals(UNDEF_TAG)) {
                this.array.remove(entry.getKey());
                continue;
            }
            this.array.put(entry.getKey(), (List<String>)entry.getValue());
        }
        for (Map.Entry<String, Object> entry : ast.getTopics().entrySet()) {
            String topic = entry.getKey();
            Topic data = (Topic)entry.getValue();
            if (!this.includes.containsKey(topic)) {
                this.includes.put(topic, new HashMap());
            }
            if (!this.inherits.containsKey(topic)) {
                this.inherits.put(topic, new HashMap());
            }
            for (String included : data.getIncludes().keySet()) {
                this.includes.get(topic).put(included, true);
            }
            for (String inherited : data.getInherits().keySet()) {
                this.inherits.get(topic).put(inherited, true);
            }
            if (!this.topics.containsKey(topic)) {
                this.topics.put(topic, new Topic());
            }
            for (Trigger astTrigger : data.getTriggers()) {
                Trigger trigger = new Trigger();
                trigger.setTrigger(astTrigger.getTrigger());
                trigger.setReply(new ArrayList<String>(astTrigger.getReply()));
                trigger.setCondition(new ArrayList<String>(astTrigger.getCondition()));
                trigger.setRedirect(astTrigger.getRedirect());
                trigger.setPrevious(astTrigger.getPrevious());
                this.topics.get(topic).addTrigger(trigger);
            }
        }
        for (ObjectMacro objectMacro : ast.getObjects()) {
            if (this.handlers.containsKey(objectMacro.getLanguage())) {
                this.handlers.get(objectMacro.getLanguage()).load(this, objectMacro.getName(), objectMacro.getCode().toArray(new String[0]));
                this.objectLanguages.put(objectMacro.getName(), objectMacro.getLanguage());
                continue;
            }
            logger.warn("Object '{}' not loaded as no handler was found for programming language '{}'", (Object)objectMacro.getName(), (Object)objectMacro.getLanguage());
        }
    }

    public void sortReplies() {
        this.sorted.getTopics().clear();
        this.sorted.getThats().clear();
        logger.debug("Sorting triggers...");
        for (String topic : this.topics.keySet()) {
            logger.debug("Analyzing topic {}", (Object)topic);
            List<SortedTriggerEntry> allTriggers = this.getTopicTriggers(topic, false, 0, 0, false);
            this.sorted.addTopic(topic, this.sortTriggerSet(allTriggers, true));
            List<SortedTriggerEntry> thatTriggers = this.getTopicTriggers(topic, true, 0, 0, false);
            this.sorted.addThats(topic, this.sortTriggerSet(thatTriggers, false));
        }
        this.sorted.setSub(this.sortList(this.sub.keySet()));
        this.sorted.setPerson(this.sortList(this.person.keySet()));
    }

    private List<SortedTriggerEntry> getTopicTriggers(String topic, boolean thats, int depth, int inheritance, boolean inherited) {
        if (this.checkDeepRecursion(depth, "Deep recursion while scanning topic inheritance!")) {
            return new ArrayList<SortedTriggerEntry>();
        }
        logger.debug("Collecting trigger list for topic {} (depth={}; inheritance={}; inherited={})", new Object[]{topic, depth, inheritance, inherited});
        ArrayList<SortedTriggerEntry> triggers = new ArrayList<SortedTriggerEntry>();
        ArrayList<SortedTriggerEntry> inThisTopic = new ArrayList<SortedTriggerEntry>();
        if (this.topics.containsKey(topic)) {
            for (Trigger trigger : this.topics.get(topic).getTriggers()) {
                SortedTriggerEntry entry;
                if (!thats) {
                    entry = new SortedTriggerEntry(trigger.getTrigger(), trigger);
                    inThisTopic.add(entry);
                    continue;
                }
                if (trigger.getPrevious() == null) continue;
                entry = new SortedTriggerEntry(trigger.getPrevious(), trigger);
                inThisTopic.add(entry);
            }
        }
        if (this.includes.containsKey(topic)) {
            for (String string : this.includes.get(topic).keySet()) {
                logger.debug("Topic {} includes {}", (Object)topic, (Object)string);
                triggers.addAll(this.getTopicTriggers(string, thats, depth + 1, inheritance + 1, false));
            }
        }
        if (this.inherits.containsKey(topic)) {
            for (String string : this.inherits.get(topic).keySet()) {
                logger.debug("Topic {} inherits {}", (Object)topic, (Object)string);
                triggers.addAll(this.getTopicTriggers(string, thats, depth + 1, inheritance + 1, true));
            }
        }
        if (this.inherits.containsKey(topic) && this.inherits.get(topic).size() > 0 || inherited) {
            for (SortedTriggerEntry sortedTriggerEntry : inThisTopic) {
                logger.debug("Prefixing trigger with {inherits={}} {}", (Object)inheritance, (Object)sortedTriggerEntry.getTrigger());
                String label = String.format("{inherits=%d}%s", inheritance, sortedTriggerEntry.getTrigger());
                triggers.add(new SortedTriggerEntry(label, sortedTriggerEntry.getPointer()));
            }
        } else {
            for (SortedTriggerEntry sortedTriggerEntry : inThisTopic) {
                triggers.add(new SortedTriggerEntry(sortedTriggerEntry.getTrigger(), sortedTriggerEntry.getPointer()));
            }
        }
        return triggers;
    }

    private List<SortedTriggerEntry> sortTriggerSet(List<SortedTriggerEntry> triggers, boolean excludePrevious) {
        HashMap priority = new HashMap();
        for (SortedTriggerEntry trigger : triggers) {
            if (excludePrevious && trigger.getPointer().getPrevious() != null) continue;
            int weight = 0;
            Matcher matcher = Regexp.RE_WEIGHT.matcher(trigger.getTrigger());
            if (matcher.find()) {
                weight = Integer.parseInt(matcher.group(1));
            }
            if (!priority.containsKey(weight)) {
                priority.put(weight, new ArrayList());
            }
            ((List)priority.get(weight)).add(trigger);
        }
        ArrayList<SortedTriggerEntry> running = new ArrayList<SortedTriggerEntry>();
        ArrayList<Integer> sortedPriorities = new ArrayList<Integer>();
        for (Integer k : priority.keySet()) {
            sortedPriorities.add(k);
        }
        Collections.sort(sortedPriorities);
        Collections.reverse(sortedPriorities);
        for (Integer p : sortedPriorities) {
            logger.debug("Sorting triggers with priority {}", (Object)p);
            int inherits = -1;
            int highestInherits = -1;
            HashMap<Integer, SortTrack> track = new HashMap<Integer, SortTrack>();
            track.put(inherits, new SortTrack());
            for (SortedTriggerEntry trigger : (List)priority.get(p)) {
                int count;
                String pattern = trigger.getTrigger();
                logger.debug("Looking at trigger: {}", (Object)pattern);
                Matcher matcher = Regexp.RE_INHERITS.matcher(pattern);
                if (matcher.find()) {
                    inherits = Integer.parseInt(matcher.group(1));
                    if (inherits > highestInherits) {
                        highestInherits = inherits;
                    }
                    logger.debug("Trigger belongs to a topic that inherits other topics. Level={}", (Object)inherits);
                    pattern = pattern.replaceAll("\\{inherits=\\d+\\}", "");
                    trigger.setTrigger(pattern);
                } else {
                    inherits = -1;
                }
                if (!track.containsKey(inherits)) {
                    track.put(inherits, new SortTrack());
                }
                if (pattern.contains("_")) {
                    count = StringUtils.countWords(pattern, false);
                    logger.debug("Has a _ wildcard with {} words", (Object)count);
                    if (count > 0) {
                        if (!((SortTrack)track.get(inherits)).getAlpha().containsKey(count)) {
                            ((SortTrack)track.get(inherits)).getAlpha().put(count, new ArrayList());
                        }
                        ((SortTrack)track.get(inherits)).getAlpha().get(count).add(trigger);
                        continue;
                    }
                    ((SortTrack)track.get(inherits)).getUnder().add(trigger);
                    continue;
                }
                if (pattern.contains("#")) {
                    count = StringUtils.countWords(pattern, false);
                    logger.debug("Has a # wildcard with {} words", (Object)count);
                    if (count > 0) {
                        if (!((SortTrack)track.get(inherits)).getNumber().containsKey(count)) {
                            ((SortTrack)track.get(inherits)).getNumber().put(count, new ArrayList());
                        }
                        ((SortTrack)track.get(inherits)).getNumber().get(count).add(trigger);
                        continue;
                    }
                    ((SortTrack)track.get(inherits)).getPound().add(trigger);
                    continue;
                }
                if (pattern.contains("*")) {
                    count = StringUtils.countWords(pattern, false);
                    logger.debug("Has a * wildcard with {} words", (Object)count);
                    if (count > 0) {
                        if (!((SortTrack)track.get(inherits)).getWild().containsKey(count)) {
                            ((SortTrack)track.get(inherits)).getWild().put(count, new ArrayList());
                        }
                        ((SortTrack)track.get(inherits)).getWild().get(count).add(trigger);
                        continue;
                    }
                    ((SortTrack)track.get(inherits)).getStar().add(trigger);
                    continue;
                }
                if (pattern.contains("[")) {
                    count = StringUtils.countWords(pattern, false);
                    logger.debug("Has optionals with {} words", (Object)count);
                    if (!((SortTrack)track.get(inherits)).getOption().containsKey(count)) {
                        ((SortTrack)track.get(inherits)).getOption().put(count, new ArrayList());
                    }
                    ((SortTrack)track.get(inherits)).getOption().get(count).add(trigger);
                    continue;
                }
                count = StringUtils.countWords(pattern, false);
                logger.debug("Totally atomic trigger with {} words", (Object)count);
                if (!((SortTrack)track.get(inherits)).getAtomic().containsKey(count)) {
                    ((SortTrack)track.get(inherits)).getAtomic().put(count, new ArrayList());
                }
                ((SortTrack)track.get(inherits)).getAtomic().get(count).add(trigger);
            }
            track.put(highestInherits + 1, (SortTrack)track.get(-1));
            track.remove(-1);
            ArrayList<Integer> trackSorted = new ArrayList<Integer>();
            for (Integer k : track.keySet()) {
                trackSorted.add(k);
            }
            Collections.sort(trackSorted);
            for (Integer ip : trackSorted) {
                logger.debug("ip={}", (Object)ip);
                running.addAll(this.sortByWords(((SortTrack)track.get(ip)).getAtomic()));
                running.addAll(this.sortByWords(((SortTrack)track.get(ip)).getOption()));
                running.addAll(this.sortByWords(((SortTrack)track.get(ip)).getAlpha()));
                running.addAll(this.sortByWords(((SortTrack)track.get(ip)).getNumber()));
                running.addAll(this.sortByWords(((SortTrack)track.get(ip)).getWild()));
                running.addAll(this.sortByLength(((SortTrack)track.get(ip)).getUnder()));
                running.addAll(this.sortByLength(((SortTrack)track.get(ip)).getPound()));
                running.addAll(this.sortByLength(((SortTrack)track.get(ip)).getStar()));
            }
        }
        return running;
    }

    private List<String> sortList(Iterable<String> list) {
        ArrayList<String> output = new ArrayList<String>();
        HashMap track = new HashMap();
        for (String item : list) {
            int count = StringUtils.countWords(item, true);
            if (!track.containsKey(count)) {
                track.put(count, new ArrayList());
            }
            ((List)track.get(count)).add(item);
        }
        ArrayList<Integer> sortedCounts = new ArrayList<Integer>();
        for (Integer count : track.keySet()) {
            sortedCounts.add(count);
        }
        Collections.sort(sortedCounts);
        Collections.reverse(sortedCounts);
        for (Integer count : sortedCounts) {
            List sortedLengths = (List)track.get(count);
            Collections.sort(sortedLengths, this.byLengthReverse());
            for (String item : sortedLengths) {
                output.add(item);
            }
        }
        return output;
    }

    private List<SortedTriggerEntry> sortByWords(Map<Integer, List<SortedTriggerEntry>> triggers) {
        ArrayList<Integer> sortedWords = new ArrayList<Integer>();
        for (Integer wc : triggers.keySet()) {
            sortedWords.add(wc);
        }
        Collections.sort(sortedWords);
        Collections.reverse(sortedWords);
        ArrayList<SortedTriggerEntry> sorted = new ArrayList<SortedTriggerEntry>();
        for (Integer wc : sortedWords) {
            ArrayList<String> sortedPatterns = new ArrayList<String>();
            HashMap patternMap = new HashMap();
            for (SortedTriggerEntry trigger : triggers.get(wc)) {
                sortedPatterns.add(trigger.getTrigger());
                if (!patternMap.containsKey(trigger.getTrigger())) {
                    patternMap.put(trigger.getTrigger(), new ArrayList());
                }
                ((List)patternMap.get(trigger.getTrigger())).add(trigger);
            }
            Collections.sort(sortedPatterns, this.byLengthReverse());
            for (String pattern : sortedPatterns) {
                sorted.addAll((Collection)patternMap.get(pattern));
            }
        }
        return sorted;
    }

    private List<SortedTriggerEntry> sortByLength(List<SortedTriggerEntry> triggers) {
        ArrayList<String> sortedPatterns = new ArrayList<String>();
        HashMap patternMap = new HashMap();
        for (SortedTriggerEntry trigger : triggers) {
            sortedPatterns.add(trigger.getTrigger());
            if (!patternMap.containsKey(trigger.getTrigger())) {
                patternMap.put(trigger.getTrigger(), new ArrayList());
            }
            ((List)patternMap.get(trigger.getTrigger())).add(trigger);
        }
        Collections.sort(sortedPatterns, this.byLengthReverse());
        HashMap<String, Boolean> patternSet = new HashMap<String, Boolean>();
        ArrayList<SortedTriggerEntry> sorted = new ArrayList<SortedTriggerEntry>();
        for (String pattern : sortedPatterns) {
            if (patternSet.containsKey(pattern) && ((Boolean)patternSet.get(pattern)).booleanValue()) continue;
            patternSet.put(pattern, true);
            sorted.addAll((Collection)patternMap.get(pattern));
        }
        return sorted;
    }

    private Comparator<String> byLengthReverse() {
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int result = Integer.compare(o2.length(), o1.length());
                if (result == 0) {
                    result = o1.compareTo(o2);
                }
                return result;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String reply(String username, String message) throws RiveScriptException {
        logger.debug("Asked to reply to [{}] {}", (Object)username, (Object)message);
        long startTime = System.currentTimeMillis();
        this.currentUser.set(username);
        try {
            String reply;
            this.sessions.init(username);
            message = this.formatMessage(message, false);
            if (this.topics.containsKey("__begin__")) {
                String begin = this.getReply(username, "request", true, 0);
                if (begin.contains("{ok}")) {
                    reply = this.getReply(username, message, false, 0);
                    begin = begin.replaceAll("\\{ok\\}", reply);
                }
                reply = begin;
                reply = this.processTags(username, message, reply, new ArrayList<String>(), new ArrayList<String>(), 0);
            } else {
                reply = this.getReply(username, message, false, 0);
            }
            this.sessions.addHistory(username, message, reply);
            if (logger.isDebugEnabled()) {
                long elapsedTime = System.currentTimeMillis() - startTime;
                logger.debug("Replied [{}] to [{}] in {} ms", new Object[]{reply, username, elapsedTime});
            }
            String string = reply;
            return string;
        }
        finally {
            this.currentUser.remove();
        }
    }

    private String getReply(String username, String message, boolean isBegin, int step) {
        boolean n;
        if (this.sorted.getTopics().size() == 0) {
            logger.warn("You forgot to call sortReplies()!");
            String errorMessage = this.errorMessages.get(REPLIES_NOT_SORTED_KEY);
            if (this.throwExceptions) {
                throw new RepliesNotSortedException(errorMessage);
            }
            return errorMessage;
        }
        String topic = this.sessions.get(username, "topic");
        if (topic == null) {
            topic = "random";
        }
        ArrayList<String> stars = new ArrayList<String>();
        ArrayList<String> thatStars = new ArrayList<String>();
        String reply = null;
        if (!this.topics.containsKey(topic)) {
            logger.warn("User {} was in an empty topic named '{}'", (Object)username, (Object)topic);
            topic = "random";
            this.sessions.set(username, "topic", topic);
        }
        if (this.checkDeepRecursion(step, "Deep recursion while getting reply!")) {
            return this.errorMessages.get(DEEP_RECURSION_KEY);
        }
        if (isBegin) {
            topic = "__begin__";
        }
        if (!this.topics.containsKey(topic)) {
            String errorMessage = this.errorMessages.get(DEFAULT_TOPIC_NOT_FOUND_KEY);
            if (this.throwExceptions) {
                throw new NoDefaultTopicException(errorMessage);
            }
            return errorMessage;
        }
        Trigger matched = null;
        String matchedTrigger = null;
        boolean foundMatch = false;
        if (step == 0) {
            List<String> allTopics = new ArrayList<String>(Arrays.asList(topic));
            if (this.includes.get(topic).size() > 0 || this.inherits.get(topic).size() > 0) {
                allTopics = this.getTopicTree(topic, 0);
            }
            block2: for (String string : allTopics) {
                logger.debug("Checking topic {} for any %Previous's", (Object)string);
                if (this.sorted.getThats(string).size() <= 0) continue;
                logger.debug("There's a %Previous in this topic!");
                History history = this.sessions.getHistory(username);
                String lastReply = history.getReply().get(0);
                lastReply = this.formatMessage(lastReply, true);
                logger.debug("Bot's last reply: {}", (Object)lastReply);
                for (SortedTriggerEntry trigger : this.sorted.getThats(string)) {
                    String pattern = trigger.getPointer().getPrevious();
                    String botside = this.triggerRegexp(username, pattern);
                    logger.debug("Try to match lastReply {} to {} ({})", new Object[]{lastReply, pattern, botside});
                    Pattern re = Pattern.compile("^" + botside + "$");
                    Matcher matcher = re.matcher(lastReply);
                    if (!matcher.find()) continue;
                    logger.debug("Bot side matched!");
                    for (int i = 1; i <= matcher.groupCount(); ++i) {
                        thatStars.add(matcher.group(i));
                    }
                    Trigger userSide = trigger.getPointer();
                    String regexp = this.triggerRegexp(username, userSide.getTrigger());
                    logger.debug("Try to match {} against {} ({})", new Object[]{message, userSide.getTrigger(), regexp});
                    boolean isMatch = false;
                    if (this.isAtomic(userSide.getTrigger())) {
                        if (message.equals(regexp)) {
                            isMatch = true;
                        }
                    } else {
                        re = Pattern.compile("^" + regexp + "$");
                        matcher = re.matcher(message);
                        if (matcher.find()) {
                            isMatch = true;
                            for (int i = 1; i <= matcher.groupCount(); ++i) {
                                stars.add(matcher.group(i));
                            }
                        }
                    }
                    if (!isMatch) continue;
                    matched = userSide;
                    foundMatch = true;
                    matchedTrigger = userSide.getTrigger();
                    continue block2;
                }
            }
        }
        if (!foundMatch) {
            logger.debug("Searching their topic for a match...");
            for (SortedTriggerEntry trigger : this.sorted.getTopic(topic)) {
                String string = trigger.getTrigger();
                String regexp = this.triggerRegexp(username, string);
                logger.debug("Try to match \"{}\" against {} ({})", new Object[]{message, string, regexp});
                boolean isMatch = false;
                if (this.isAtomic(string) && message.equals(regexp)) {
                    isMatch = true;
                } else {
                    Pattern re = Pattern.compile("^" + regexp + "$");
                    Matcher matcher = re.matcher(message);
                    if (matcher.find()) {
                        isMatch = true;
                        for (int i = 1; i <= matcher.groupCount(); ++i) {
                            stars.add(matcher.group(i));
                        }
                    }
                }
                if (!isMatch) continue;
                logger.debug("Found a match!");
                matched = trigger.getPointer();
                foundMatch = true;
                matchedTrigger = string;
                break;
            }
        }
        this.sessions.setLastMatch(username, matchedTrigger);
        if (foundMatch && (n = false) < true) {
            if (matched.getRedirect() != null && matched.getRedirect().length() > 0) {
                logger.debug("Redirecting us to {}", (Object)matched.getRedirect());
                Object redirect = matched.getRedirect();
                redirect = this.processTags(username, message, (String)redirect, stars, thatStars, 0);
                redirect = ((String)redirect).toLowerCase();
                logger.debug("Pretend user said: {}", redirect);
                reply = this.getReply(username, (String)redirect, isBegin, step + 1);
            } else {
                for (String string : matched.getCondition()) {
                    Matcher matcher;
                    String[] halves = string.split("=>");
                    if (halves.length != 2 || !(matcher = Regexp.RE_CONDITION.matcher(halves[0].trim())).find()) continue;
                    String left = matcher.group(1).trim();
                    String eq = matcher.group(2);
                    String right = matcher.group(3).trim();
                    String potentialReply = halves[1].trim();
                    left = this.processTags(username, message, left, stars, thatStars, step);
                    right = this.processTags(username, message, right, stars, thatStars, step);
                    if (left.length() == 0) {
                        left = UNDEFINED;
                    }
                    if (right.length() == 0) {
                        right = UNDEFINED;
                    }
                    logger.debug("Check if {} {} {}", new Object[]{left, eq, right});
                    boolean passed = false;
                    if (eq.equals("eq") || eq.equals("==")) {
                        if (left.equals(right)) {
                            passed = true;
                        }
                    } else if (eq.equals("ne") || eq.equals("!=") || eq.equals("<>")) {
                        if (!left.equals(right)) {
                            passed = true;
                        }
                    } else {
                        try {
                            int intLeft = Integer.parseInt(left);
                            int intRight = Integer.parseInt(right);
                            if (eq.equals("<") && intLeft < intRight) {
                                passed = true;
                            } else if (eq.equals("<=") && intLeft <= intRight) {
                                passed = true;
                            } else if (eq.equals(">") && intLeft > intRight) {
                                passed = true;
                            } else if (eq.equals(">=") && intLeft >= intRight) {
                                passed = true;
                            }
                        }
                        catch (NumberFormatException e) {
                            logger.warn("Failed to evaluate numeric condition!");
                        }
                    }
                    if (!passed) continue;
                    reply = potentialReply;
                    break;
                }
                if (reply == null || reply.length() <= 0) {
                    ArrayList<String> bucket = new ArrayList<String>();
                    for (String rep : matched.getReply()) {
                        Matcher matcher = Regexp.RE_WEIGHT.matcher(rep);
                        if (matcher.find()) {
                            int weight = Integer.parseInt(matcher.group(1));
                            if (weight <= 0) {
                                weight = 1;
                            }
                            for (int i = weight; i > 0; --i) {
                                bucket.add(rep);
                            }
                            continue;
                        }
                        bucket.add(rep);
                    }
                    if (bucket.size() > 0) {
                        reply = (String)bucket.get(RANDOM.nextInt(bucket.size()));
                    }
                }
            }
        }
        if (!foundMatch) {
            String errorMessage = this.errorMessages.get(REPLY_NOT_MATCHED_KEY);
            if (this.throwExceptions) {
                throw new ReplyNotMatchedException(errorMessage);
            }
            reply = errorMessage;
        } else if (reply == null || reply.length() == 0) {
            String errorMessage = this.errorMessages.get(REPLY_NOT_FOUND_KEY);
            if (this.throwExceptions) {
                throw new ReplyNotFoundException(errorMessage);
            }
            reply = errorMessage;
        }
        logger.debug("Reply: {}", (Object)reply);
        if (isBegin) {
            Matcher matcher = Regexp.RE_TOPIC.matcher(reply);
            int giveup = 0;
            while (matcher.find() && !this.checkDeepRecursion(++giveup, "Infinite loop looking for topic tag!")) {
                String string = matcher.group(1);
                this.sessions.set(username, "topic", string);
                reply = reply.replace(matcher.group(0), "");
            }
            matcher = Regexp.RE_SET.matcher(reply);
            giveup = 0;
            while (matcher.find() && !this.checkDeepRecursion(++giveup, "Infinite loop looking for set tag!")) {
                String string = matcher.group(1);
                String value = matcher.group(2);
                this.sessions.set(username, string, value);
                reply = reply.replace(matcher.group(0), "");
            }
        } else {
            reply = this.processTags(username, message, reply, stars, thatStars, 0);
        }
        return reply;
    }

    private String formatMessage(String message, boolean botReply) {
        message = "" + message;
        message = message.toLowerCase();
        message = this.substitute(message, this.sub, this.sorted.getSub());
        if (this.utf8) {
            message = Regexp.RE_META.matcher(message).replaceAll("");
            if (this.unicodePunctuation != null) {
                message = this.unicodePunctuation.matcher(message).replaceAll("");
            }
            if (botReply) {
                message = Regexp.RE_SYMBOLS.matcher(message).replaceAll("");
            }
        } else {
            message = StringUtils.stripNasties(message);
        }
        message = message.trim();
        message = message.replaceAll("\\s+", " ");
        return message;
    }

    private String processTags(String username, String message, String reply, List<String> st, List<String> bst, int step) {
        Object text;
        int i;
        ArrayList<String> stars = new ArrayList<String>();
        stars.add("");
        stars.addAll(st);
        ArrayList<String> botstars = new ArrayList<String>();
        botstars.add("");
        botstars.addAll(bst);
        if (stars.size() == 1) {
            stars.add(UNDEFINED);
        }
        if (botstars.size() == 1) {
            botstars.add(UNDEFINED);
        }
        Pattern re = Pattern.compile("\\(@([A-Za-z0-9_]+)\\)");
        Matcher matcher = re.matcher(reply);
        int giveup = 0;
        while (matcher.find() && !this.checkDeepRecursion(giveup, "Infinite loop looking for arrays in reply!")) {
            String name = matcher.group(1);
            String result = this.array.containsKey(name) ? "{random}" + StringUtils.join(this.array.get(name).toArray(new String[0]), "|") + "{/random}" : "\\x00@" + name + "\\x00";
            reply = reply.replace(matcher.group(0), result);
        }
        reply = reply.replaceAll("\\\\x00@([A-Za-z0-9_]+)\\\\x00", "(@$1)");
        reply = reply.replaceAll("<person>", "{person}<star>{/person}");
        reply = reply.replaceAll("<@>", "{@<star>}");
        reply = reply.replaceAll("<formal>", "{formal}<star>{/formal}");
        reply = reply.replaceAll("<sentence>", "{sentence}<star>{/sentence}");
        reply = reply.replaceAll("<uppercase>", "{uppercase}<star>{/uppercase}");
        reply = reply.replaceAll("<lowercase>", "{lowercase}<star>{/lowercase}");
        reply = Regexp.RE_WEIGHT.matcher(reply).replaceAll("");
        reply = reply.replaceAll("<star>", (String)stars.get(1));
        reply = reply.replaceAll("<botstar>", (String)botstars.get(1));
        for (i = 1; i < stars.size(); ++i) {
            reply = reply.replaceAll("<star" + i + ">", (String)stars.get(i));
        }
        for (i = 1; i < botstars.size(); ++i) {
            reply = reply.replaceAll("<botstar" + i + ">", (String)botstars.get(i));
        }
        reply = reply.replaceAll("<input>", "<input1>");
        reply = reply.replaceAll("<reply>", "<reply1>");
        History history = this.sessions.getHistory(username);
        if (history != null) {
            for (int i2 = 1; i2 <= 9; ++i2) {
                reply = reply.replaceAll("<input" + i2 + ">", history.getInput(i2 - 1));
                reply = reply.replaceAll("<reply" + i2 + ">", history.getReply(i2 - 1));
            }
        }
        reply = reply.replaceAll("<id>", username);
        reply = reply.replaceAll("\\\\s", " ");
        reply = reply.replaceAll("\\\\n", "\n");
        reply = reply.replaceAll("\\#", "#");
        matcher = Regexp.RE_RANDOM.matcher(reply);
        giveup = 0;
        while (matcher.find() && !this.checkDeepRecursion(++giveup, "Infinite loop looking for random tag!")) {
            text = matcher.group(1);
            String[] random = ((String)text).contains("|") ? ((String)text).split("\\|") : ((String)text).split(" ");
            String output = "";
            if (random.length > 0) {
                output = random[RANDOM.nextInt(random.length)];
            }
            reply = reply.replace(matcher.group(0), output);
        }
        String[] formats = new String[]{"person", "formal", "sentence", "uppercase", "lowercase"};
        for (String format : formats) {
            re = Pattern.compile("\\{" + format + "\\}(.+?)\\{\\/" + format + "\\}");
            matcher = re.matcher(reply);
            giveup = 0;
            while (matcher.find() && !this.checkDeepRecursion(++giveup, "Infinite loop looking for {} tag!")) {
                String content = matcher.group(1);
                String replace = null;
                if (format.equals("person")) {
                    replace = this.substitute(content, this.person, this.sorted.getPerson());
                } else if (format.equals("uppercase")) {
                    replace = content.toUpperCase();
                } else if (format.equals("lowercase")) {
                    replace = content.toLowerCase();
                } else if (format.equals("sentence")) {
                    replace = content.length() > 1 ? content.substring(0, 1).toUpperCase() + content.substring(1).toLowerCase() : content.toUpperCase();
                } else if (format.equals("formal")) {
                    String[] words = content.split(" ");
                    for (int i3 = 0; i3 < words.length; ++i3) {
                        String word = words[i3];
                        words[i3] = word.length() > 1 ? word.substring(0, 1).toUpperCase() + word.substring(1).toLowerCase() : word.toUpperCase();
                    }
                    replace = StringUtils.join(words, " ");
                }
                reply = reply.replace(matcher.group(0), replace);
            }
        }
        reply = reply.replaceAll("<call>", "{__call__}");
        reply = reply.replaceAll("</call>", "{/__call__}");
        while ((matcher = Regexp.RE_ANY_TAG.matcher(reply)).find()) {
            String name;
            String match = matcher.group(1);
            String[] parts = match.split(" ");
            String tag = parts[0].toLowerCase();
            String data = "";
            if (parts.length > 1) {
                data = StringUtils.join(Arrays.copyOfRange(parts, 1, parts.length), " ");
            }
            String insert = "";
            if (tag.equals("bot") || tag.equals("env")) {
                Map<String, String> target = tag.equals("bot") ? this.vars : this.global;
                if (data.contains("=")) {
                    parts = data.split("=", 2);
                    String name2 = parts[0];
                    String value = parts[1];
                    logger.debug("Assign {} variable {} = {}", new Object[]{tag, name2, value});
                    target.put(name2, value);
                } else {
                    insert = target.containsKey(data) ? target.get(data) : UNDEFINED;
                }
            } else if (tag.equals("set")) {
                parts = data.split("=", 2);
                if (parts.length > 1) {
                    name = parts[0];
                    String value = parts[1];
                    logger.debug("Set uservar {} = {}", (Object)name, (Object)value);
                    this.sessions.set(username, name, value);
                } else {
                    logger.warn("Malformed <set> tag: {}", (Object)match);
                }
            } else if (tag.equals("add") || tag.equals("sub") || tag.equals("mult") || tag.equals("div")) {
                parts = data.split("=", 2);
                name = parts[0];
                String strValue = parts[1];
                int result = 0;
                String origStr = this.sessions.get(username, name);
                if (origStr == null) {
                    origStr = "0";
                    this.sessions.set(username, name, origStr);
                }
                try {
                    int value = Integer.parseInt(strValue);
                    try {
                        result = Integer.parseInt(origStr);
                        if (tag.equals("add")) {
                            result += value;
                        } else if (tag.equals("sub")) {
                            result -= value;
                        } else if (tag.equals("mult")) {
                            result *= value;
                        } else {
                            if (value == 0) {
                                logger.warn("Can't divide by zero");
                                insert = this.errorMessages.get(CANNOT_DIVIDE_BY_ZERO_KEY);
                            }
                            result /= value;
                        }
                        this.sessions.set(username, name, Integer.toString(result));
                    }
                    catch (NumberFormatException e) {
                        logger.warn("Math can't " + tag + " non-numeric variable " + name);
                        insert = this.errorMessages.get(CANNOT_MATH_VARIABLE_KEY);
                    }
                }
                catch (NumberFormatException e) {
                    logger.warn("Math can't " + tag + " non-numeric value " + strValue);
                    insert = this.errorMessages.get(CANNOT_MATH_VALUE_KEY);
                }
            } else if (tag.equals("get")) {
                insert = this.sessions.get(username, data);
                if (insert == null) {
                    insert = UNDEFINED;
                }
            } else {
                insert = "\\x00" + match + "\\x01";
            }
            reply = reply.replace(matcher.group(0), insert);
        }
        reply = reply.replaceAll("\\\\x00", "<");
        reply = reply.replaceAll("\\\\x01", ">");
        matcher = Regexp.RE_TOPIC.matcher(reply);
        giveup = 0;
        while (matcher.find() && !this.checkDeepRecursion(++giveup, "Infinite loop looking for topic tag!")) {
            String name = matcher.group(1);
            this.sessions.set(username, "topic", name);
            reply = reply.replace(matcher.group(0), "");
        }
        matcher = Regexp.RE_REDIRECT.matcher(reply);
        giveup = 0;
        while (matcher.find() && !this.checkDeepRecursion(++giveup, "Infinite loop looking for redirect tag!")) {
            String target = matcher.group(1);
            logger.debug("Inline redirection to: {}", (Object)target);
            String subreply = this.getReply(username, target.trim(), false, step + 1);
            reply = reply.replace(matcher.group(0), subreply);
        }
        reply = reply.replaceAll("\\{__call__\\}", "<call>");
        reply = reply.replaceAll("\\{/__call__\\}", "</call>");
        matcher = Regexp.RE_CALL.matcher(reply);
        giveup = 0;
        while (matcher.find() && !this.checkDeepRecursion(++giveup, "Infinite loop looking for call tag!")) {
            String output;
            text = matcher.group(1).trim();
            String[] parts = ((String)text).split(" ", 2);
            String obj = parts[0];
            String[] args = parts.length > 1 ? this.parseCallArgsString(parts[1]) : new String[]{};
            if (this.subroutines.containsKey(obj)) {
                output = this.subroutines.get(obj).call(this, args);
            } else if (this.objectLanguages.containsKey(obj)) {
                String language = this.objectLanguages.get(obj);
                output = this.handlers.get(language).call(this, obj, args);
            } else {
                output = this.errorMessages.get(OBJECT_NOT_FOUND_KEY);
            }
            if (output == null) {
                output = "";
            }
            reply = reply.replace(matcher.group(0), output);
        }
        return reply;
    }

    private String[] parseCallArgsString(String args) {
        ArrayList<String> result = new ArrayList<String>();
        String buffer = "";
        boolean insideAString = false;
        if (args != null) {
            for (char c : args.toCharArray()) {
                if (Character.isWhitespace(c) && !insideAString) {
                    if (buffer.length() > 0) {
                        result.add(buffer);
                    }
                    buffer = "";
                    continue;
                }
                if (c == '\"') {
                    if (insideAString) {
                        if (buffer.length() > 0) {
                            result.add(buffer);
                        }
                        buffer = "";
                    }
                    insideAString = !insideAString;
                    continue;
                }
                buffer = buffer + c;
            }
            if (buffer.length() > 0) {
                result.add(buffer);
            }
        }
        return result.toArray(new String[0]);
    }

    private String substitute(String message, Map<String, String> subs, List<String> sorted) {
        if (subs == null || subs.size() == 0) {
            return message;
        }
        ArrayList<String> ph = new ArrayList<String>();
        int pi = 0;
        for (String pattern : sorted) {
            String result = subs.get(pattern);
            String qm = StringUtils.quoteMetacharacters(pattern);
            ph.add(result);
            String placeholder = "\\\\x00" + pi + "\\\\x00";
            ++pi;
            message = message.replaceAll("^" + qm + "$", placeholder);
            message = message.replaceAll("^" + qm + "(\\W+)", placeholder + "$1");
            message = message.replaceAll("(\\W+)" + qm + "(\\W+)", "$1" + placeholder + "$2");
            message = message.replaceAll("(\\W+)" + qm + "$", "$1" + placeholder);
        }
        int tries = 0;
        while (message.contains("\\x00") && !this.checkDeepRecursion(++tries, "Too many loops in substitution placeholders!")) {
            Matcher matcher = Regexp.RE_PLACEHOLDER.matcher(message);
            if (!matcher.find()) continue;
            int i = Integer.parseInt(matcher.group(1));
            String result = (String)ph.get(i);
            message = message.replace(matcher.group(0), result);
        }
        return message;
    }

    private List<String> getTopicTree(String topic, int depth) {
        if (this.checkDeepRecursion(depth, "Deep recursion while scanning topic tree!")) {
            return new ArrayList<String>();
        }
        ArrayList<String> topics = new ArrayList<String>(Arrays.asList(topic));
        for (String includes : this.topics.get(topic).getIncludes().keySet()) {
            topics.addAll(this.getTopicTree(includes, depth + 1));
        }
        for (String inherits : this.topics.get(topic).getInherits().keySet()) {
            topics.addAll(this.getTopicTree(inherits, depth + 1));
        }
        return topics;
    }

    private String triggerRegexp(String username, String pattern) {
        String rep;
        String name;
        pattern = Regexp.RE_ZERO_WITH_STAR.matcher(pattern).replaceAll("<zerowidthstar>");
        pattern = pattern.replaceAll("\\*", "(.+?)");
        pattern = pattern.replaceAll("#", "(\\\\d+?)");
        pattern = pattern.replaceAll("(?<!\\\\)_", "(\\\\w+?)");
        pattern = pattern.replaceAll("\\\\_", "_");
        pattern = pattern.replaceAll("\\s*\\{weight=\\d+\\}\\s*", "");
        pattern = pattern.replaceAll("<zerowidthstar>", "(.*?)");
        pattern = pattern.replaceAll("\\|{2,}", "|");
        pattern = pattern.replaceAll("(\\(|\\[)\\|", "$1");
        pattern = pattern.replaceAll("\\|(\\)|\\])", "$1");
        if (this.utf8) {
            pattern = pattern.replaceAll("\\\\@", "\\\\u0040");
        }
        Matcher matcher = Regexp.RE_OPTIONAL.matcher(pattern);
        int giveup = 0;
        while (matcher.find()) {
            if (this.checkDeepRecursion(++giveup, "Infinite loop when trying to process optionals in a trigger!")) {
                return "";
            }
            String[] parts = matcher.group(1).split("\\|");
            ArrayList<String> opts = new ArrayList<String>();
            for (String p : parts) {
                opts.add("(?:\\s|\\b)+" + p + "(?:\\s|\\b)+");
            }
            String pipes = StringUtils.join(opts.toArray(new String[0]), "|");
            pipes = pipes.replaceAll(StringUtils.quoteMetacharacters("(.+?)"), "(?:.+?)");
            pipes = pipes.replaceAll(StringUtils.quoteMetacharacters("(\\d+?)"), "(?:\\\\d+?)");
            pipes = pipes.replaceAll(StringUtils.quoteMetacharacters("(\\w+?)"), "(?:\\\\w+?)");
            pipes = "(?:" + pipes + "|(?:\\s|\\b)+)";
            pattern = pattern.replaceAll("\\s*\\[" + StringUtils.quoteMetacharacters(matcher.group(1)) + "\\]\\s*", StringUtils.quoteMetacharacters(pipes));
        }
        pattern = pattern.replaceAll("\\\\w", "[^\\\\s\\\\d]");
        giveup = 0;
        matcher = Regexp.RE_ARRAY.matcher(pattern);
        while (matcher.find() && !this.checkDeepRecursion(++giveup, "Infinite loop looking when trying to process arrays in a trigger!")) {
            name = matcher.group(1);
            rep = "";
            if (this.array.containsKey(name)) {
                rep = "(?:" + StringUtils.join(this.array.get(name).toArray(new String[0]), "|") + ")";
            }
            pattern = pattern.replace(matcher.group(0), rep);
        }
        giveup = 0;
        matcher = Regexp.RE_BOT_VAR.matcher(pattern);
        while (matcher.find() && !this.checkDeepRecursion(++giveup, "Infinite loop looking when trying to process bot variables in a trigger!")) {
            name = matcher.group(1);
            rep = "";
            if (this.vars.containsKey(name)) {
                rep = StringUtils.stripNasties(this.vars.get(name));
            }
            pattern = pattern.replace(matcher.group(0), rep.toLowerCase());
        }
        giveup = 0;
        matcher = Regexp.RE_USER_VAR.matcher(pattern);
        while (matcher.find() && !this.checkDeepRecursion(++giveup, "Infinite loop looking when trying to process user variables in a trigger!")) {
            name = matcher.group(1);
            rep = UNDEFINED;
            String value = this.sessions.get(username, name);
            if (value != null) {
                rep = value;
            }
            pattern = pattern.replace(matcher.group(0), rep.toLowerCase());
        }
        giveup = 0;
        pattern = pattern.replaceAll("<input>", "<input1>");
        pattern = pattern.replaceAll("<reply>", "<reply1>");
        while ((pattern.contains("<input") || pattern.contains("<reply")) && !this.checkDeepRecursion(++giveup, "Infinite loop looking when trying to process input and reply tags in a trigger!")) {
            for (int i = 1; i <= 9; ++i) {
                String inputPattern = "<input" + i + ">";
                String replyPattern = "<reply" + i + ">";
                History history = this.sessions.getHistory(username);
                if (history == null) {
                    pattern = pattern.replace(inputPattern, history.getInput(i - 1));
                    pattern = pattern.replace(replyPattern, history.getReply(i - 1));
                    continue;
                }
                pattern = pattern.replace(inputPattern, UNDEFINED);
                pattern = pattern.replace(replyPattern, UNDEFINED);
            }
        }
        if (this.utf8) {
            pattern = pattern.replaceAll("\\u0040", "@");
        }
        return pattern;
    }

    private boolean isAtomic(String pattern) {
        List<String> specials = Arrays.asList("*", "#", "_", "(", "[", "<", "@");
        for (String special : specials) {
            if (!pattern.contains(special)) continue;
            return false;
        }
        return true;
    }

    public void setUservar(String username, String name, String value) {
        this.sessions.set(username, name, value);
    }

    public void setUservars(String username, Map<String, String> vars) {
        this.sessions.set(username, vars);
    }

    public String getUservar(String username, String name) {
        return this.sessions.get(username, name);
    }

    public UserData getUservars(String username) {
        return this.sessions.get(username);
    }

    public void clearAllUservars() {
        this.sessions.clearAll();
    }

    public void clearUservars(String username) {
        this.sessions.clear(username);
    }

    public void freezeUservars(String username) {
        this.sessions.freeze(username);
    }

    public void thawUservars(String username, ThawAction action) {
        this.sessions.thaw(username, action);
    }

    public String lastMatch(String username) {
        return this.sessions.getLastMatch(username);
    }

    public String currentUser() {
        return this.currentUser.get();
    }

    public void dumpSorted() {
        this.dumpSorted(this.sorted.getTopics(), "Topics");
        this.dumpSorted(this.sorted.getThats(), "Thats");
        this.dumpSortedList(this.sorted.getSub(), "Substitutions");
        this.dumpSortedList(this.sorted.getPerson(), "Person Substitutions");
    }

    private void dumpSorted(Map<String, List<SortedTriggerEntry>> tree, String label) {
        System.out.println("Sort buffer: " + label);
        for (Map.Entry<String, List<SortedTriggerEntry>> entry : tree.entrySet()) {
            String topic = entry.getKey();
            List<SortedTriggerEntry> data = entry.getValue();
            System.out.println("  Topic: " + topic);
            for (SortedTriggerEntry trigger : data) {
                System.out.println("    + " + trigger.getTrigger());
            }
        }
    }

    private void dumpSortedList(List<String> list, String label) {
        System.out.println("Sort buffer: " + label);
        for (String item : list) {
            System.out.println("  " + item);
        }
    }

    public void dumpTopics() {
        for (Map.Entry<String, Topic> entry : this.topics.entrySet()) {
            String topic = entry.getKey();
            Topic data = entry.getValue();
            System.out.println("Topic: " + topic);
            for (Trigger trigger : data.getTriggers()) {
                System.out.println("  + " + trigger.getTrigger());
                if (trigger.getPrevious() != null) {
                    System.out.println("    % " + trigger.getPrevious());
                }
                for (String condition : trigger.getCondition()) {
                    System.out.println("    * " + condition);
                }
                for (String reply : trigger.getReply()) {
                    System.out.println("    - " + reply);
                }
                if (trigger.getRedirect() == null) continue;
                System.out.println("    @ " + trigger.getRedirect());
            }
        }
    }

    public Map<String, Topic> getTopics() {
        return this.topics;
    }
}

