/*
 * Decompiled with CFR 0.152.
 */
package com.rivescript.cmd;

import com.rivescript.ConcatMode;
import com.rivescript.Config;
import com.rivescript.RiveScript;
import com.rivescript.RiveScriptException;
import com.rivescript.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class Shell {
    private boolean strict = true;
    private boolean utf8 = false;
    private boolean forceCase = false;
    private ConcatMode concat = Config.DEFAULT_CONCAT;
    private int depth = 50;
    private boolean noColor = false;

    protected void init(RiveScript rs) {
    }

    protected void run(String[] args) {
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        Iterator it = arguments.iterator();
        while (it.hasNext()) {
            String argument = (String)it.next();
            if (argument.charAt(0) != '-') continue;
            String flag = argument.replaceAll("^-*", "").trim();
            if (flag.equals("version")) {
                System.out.println("RiveScript-Java version " + RiveScript.getVersion());
                System.exit(0);
            } else if (flag.equals("nostrict")) {
                this.strict = false;
            } else if (flag.equals("utf8")) {
                this.utf8 = true;
            } else if (flag.equals("forcecase")) {
                this.forceCase = true;
            } else if (flag.equals("concat")) {
                this.concat = ConcatMode.fromName(flag.split("=", 2)[1]);
            } else if (flag.startsWith("depth")) {
                this.depth = Integer.parseInt(flag.split("=", 2)[1]);
            } else if (flag.equals("nocolor")) {
                this.noColor = true;
            }
            it.remove();
        }
        if (arguments.size() == 0) {
            System.err.println("Usage: java com.rivescript.cmd.Shell [options] </path/to/documents>");
            System.exit(0);
        }
        String root = (String)arguments.get(0);
        Config config = Config.newBuilder().throwExceptions(true).strict(this.strict).utf8(this.utf8).forceCase(this.forceCase).concat(this.concat).depth(this.depth).build();
        RiveScript rs = new RiveScript(config);
        this.init(rs);
        rs.loadDirectory(root, new String[0]);
        rs.sortReplies();
        System.out.println("      .   .       \n     .:...::      RiveScript Interpreter (Java)\n    .::   ::.     Library Version: " + RiveScript.getVersion() + "\n ..:;;. ' .;;:..  \n    .  '''  .     Type '/quit' to quit.\n     :;,:,;:      Type '/help' for more options.\n     :     :      \n\nUsing the RiveScript bot found in: " + root + "\nType a message to the bot and press Return to send it.");
        this.run(rs);
    }

    protected void run(RiveScript rs) {
        BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            this.print(Color.YELLOW, "You>");
            String text = "";
            try {
                text = stdin.readLine();
            }
            catch (IOException e) {
                this.print(Color.RED, "Read error!", "\n");
            }
            if ((text = text.trim()).length() == 0) continue;
            if (text.startsWith("/help")) {
                this.help();
                continue;
            }
            if (text.startsWith("/quit")) {
                System.exit(0);
                continue;
            }
            if (text.startsWith("/dump t")) {
                rs.dumpTopics();
                continue;
            }
            if (text.startsWith("/dump s")) {
                rs.dumpSorted();
                continue;
            }
            try {
                String reply = rs.reply("local-user", text);
                this.print(Color.GREEN, "RiveScript>", reply, "\n");
                continue;
            }
            catch (RiveScriptException e) {
                this.print(Color.RED, "Error>", e.getMessage(), "\n");
                continue;
            }
            break;
        }
    }

    protected void print(Color color, String ... text) {
        if (this.noColor) {
            System.out.print(StringUtils.join(text, " "));
        } else {
            System.out.print(String.format("\u001b[3%sm%s\u001b[0m %s", color.getCode(), text[0], StringUtils.join(Arrays.copyOfRange(text, 1, text.length), " ")));
        }
    }

    private void help() {
        System.out.println("Supported commands:\n- /help\n    Show this text.\n- /quit\n    Exit the program.\n- /dump <topics|sorted>\n    For debugging purposes, dump the topic and sorted trigger trees.");
    }

    public static void main(String[] args) {
        new Shell().run(args);
    }

    protected static enum Color {
        RED("1"),
        YELLOW("3"),
        GREEN("2"),
        CYAN("6");

        private String code;

        private Color(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

