/*
 * Decompiled with CFR 0.152.
 */
package com.rivescript.util;

import com.rivescript.regexp.Regexp;
import java.util.HashSet;
import java.util.Set;

public class StringUtils {
    private static final char ESCAPE_CHAR = '\\';
    private static final Set<Character> UNSAFE_CHARS = new HashSet<Character>();

    public static int countWords(String str, boolean all) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        String[] words = all ? str.split("\\s+") : str.split("[\\s\\*\\#\\_\\|]+");
        int count = 0;
        for (String word : words) {
            if (word.length() <= 0) continue;
            ++count;
        }
        return count;
    }

    public static String join(String[] array, String delimiter) {
        if (array == null) {
            return null;
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            buf.append(array[i]);
            if (i >= array.length - 1) continue;
            buf.append(delimiter);
        }
        return buf.toString();
    }

    public static String quoteMetacharacters(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (UNSAFE_CHARS.contains(Character.valueOf(c))) {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String stripNasties(String str) {
        if (str == null) {
            return null;
        }
        return Regexp.RE_NASTIES.matcher(str).replaceAll("");
    }

    static {
        UNSAFE_CHARS.add(Character.valueOf('\\'));
        UNSAFE_CHARS.add(Character.valueOf('.'));
        UNSAFE_CHARS.add(Character.valueOf('+'));
        UNSAFE_CHARS.add(Character.valueOf('*'));
        UNSAFE_CHARS.add(Character.valueOf('?'));
        UNSAFE_CHARS.add(Character.valueOf('['));
        UNSAFE_CHARS.add(Character.valueOf('^'));
        UNSAFE_CHARS.add(Character.valueOf(']'));
        UNSAFE_CHARS.add(Character.valueOf('$'));
        UNSAFE_CHARS.add(Character.valueOf('('));
        UNSAFE_CHARS.add(Character.valueOf(')'));
        UNSAFE_CHARS.add(Character.valueOf('{'));
        UNSAFE_CHARS.add(Character.valueOf('}'));
        UNSAFE_CHARS.add(Character.valueOf('='));
        UNSAFE_CHARS.add(Character.valueOf('!'));
        UNSAFE_CHARS.add(Character.valueOf('<'));
        UNSAFE_CHARS.add(Character.valueOf('>'));
        UNSAFE_CHARS.add(Character.valueOf('|'));
        UNSAFE_CHARS.add(Character.valueOf(':'));
    }
}

