/*
 * Decompiled with CFR 0.152.
 */
package de.citunius.bbp.rmi;

import de.citunius.bbp.rmi.BusinessBotInterface;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

public class RMIClient {
    public static final String BBP_SYSTEM_RMI_HOST_DEFAULT = "127.0.0.1";
    public static final int BBP_SYSTEM_RMI_PORT_DEFAULT = 1099;
    public int bbpRMIPort;

    public RMIClient() {
        this.bbpRMIPort = 1099;
    }

    public RMIClient(int customRMIPort) {
        this.bbpRMIPort = customRMIPort;
    }

    public String pingBusinessBotPlatform(String echoStr) {
        try {
            Registry myRegistry = LocateRegistry.getRegistry(BBP_SYSTEM_RMI_HOST_DEFAULT, this.bbpRMIPort);
            BusinessBotInterface impl = (BusinessBotInterface)myRegistry.lookup("businessBotInterface");
            return impl.pingBusinessBotPlatform(echoStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean createMessageEventAndJob(String apiId, String apiKey, String jsonMessageEvent, String defaultLanguage) {
        try {
            Registry myRegistry = LocateRegistry.getRegistry(BBP_SYSTEM_RMI_HOST_DEFAULT, this.bbpRMIPort);
            BusinessBotInterface impl = (BusinessBotInterface)myRegistry.lookup("businessBotInterface");
            return impl.createMessageEventAndJob(apiId, apiKey, jsonMessageEvent, defaultLanguage);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean createSystemEventAndJob(String apiId, String apiKey, String jsonSystemEvent, int botId) {
        try {
            Registry myRegistry = LocateRegistry.getRegistry(BBP_SYSTEM_RMI_HOST_DEFAULT, this.bbpRMIPort);
            BusinessBotInterface impl = (BusinessBotInterface)myRegistry.lookup("businessBotInterface");
            return impl.createSystemEventAndJob(apiId, apiKey, jsonSystemEvent, botId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void main(String[] args) {
        RMIClient rmiClient = new RMIClient();
        System.out.println("Message from Business Bot Platform: " + rmiClient.pingBusinessBotPlatform("Ping the Business Bot Platform"));
    }
}

