/*
 * Decompiled with CFR 0.152.
 */
package de.citunius.businesslogicapi.common;

public class OSValidator {
    private static String OS = System.getProperty("os.name").toLowerCase();

    public static boolean isWindows() {
        return OS.indexOf("win") >= 0;
    }

    public static boolean isMac() {
        return OS.indexOf("mac") >= 0;
    }

    public static boolean isUnix() {
        return OS.indexOf("nix") >= 0 || OS.indexOf("nux") >= 0 || OS.indexOf("aix") > 0;
    }

    public static boolean isSolaris() {
        return OS.indexOf("sunos") >= 0;
    }

    public static String getOS() {
        if (OSValidator.isWindows()) {
            return "win";
        }
        if (OSValidator.isMac()) {
            return "osx";
        }
        if (OSValidator.isUnix()) {
            return "uni";
        }
        if (OSValidator.isSolaris()) {
            return "sol";
        }
        return "err";
    }
}

