/*
 * Decompiled with CFR 0.152.
 */
package de.citunius.businesslogicapi.common.services;

import de.citunius.bbp.objects.AnonymousUserAccount;
import de.citunius.bbp.objects.ChatbotCallback;
import de.citunius.bbp.objects.ChatbotTaskSchedule;
import de.citunius.bbp.objects.MobileUserAccount;
import de.citunius.businesslogicapi.common.ConstantsPlugin;
import de.citunius.businesslogicapi.common.Utilities;
import de.citunius.businesslogicapi.common.services.WebService;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;

public class CallbackService {
    static Logger logger = Logger.getLogger(MethodHandles.lookup().lookupClass());
    public static final String CRONSCHEDULE_EVERY_MINUTE = "0 0/1 * * * ? *";
    public static final String CRONSCHEDULE_EVERY_WORKDAY = "0 15 10 ? * MON-FRI";
    public static final String CRONSCHEDULE_EVERY_DAY = "0 15 10 * * ? *";
    public static final String CRONSCHEDULE_EVERY_WEEK = "0 15 10 ? * MON";
    public static final String CRONSCHEDULE_EVERY_MONTH = "0 15 10 15 * ?";
    public String tenantId = null;
    public String accountId = null;
    public HashMap<String, String> pluginMap = null;

    public CallbackService(String tenantId, String accountId, HashMap<String, String> pluginMap) {
        logger.info((Object)"called");
        this.tenantId = tenantId;
        this.accountId = accountId;
        this.pluginMap = pluginMap;
        logger.info((Object)("tenantId: [" + tenantId + "] accountId: [" + accountId + "]"));
    }

    public boolean scheduleCallback(String cronSchedule, boolean hasAnonymousUserAccount, AnonymousUserAccount anonymousUserAccount, boolean hasMobileUserAccount, MobileUserAccount mobileUserAccount) {
        logger.info((Object)"UserAccount prepared");
        logger.info((Object)("    |- hasAnonymousUserAccount: [" + hasAnonymousUserAccount + "] AnonymousUserAccountId: [" + (anonymousUserAccount != null ? Integer.valueOf(anonymousUserAccount.getId()) : "NULL") + "]"));
        logger.info((Object)("    |- hasMobileUserAccount: [" + hasMobileUserAccount + "] MobileUserAccountId: [" + (mobileUserAccount != null ? Integer.valueOf(mobileUserAccount.getId()) : "NULL") + "]"));
        String userId = null;
        if (hasAnonymousUserAccount) {
            if (anonymousUserAccount == null) {
                logger.error((Object)"AnonymousUserAccount is null");
                return false;
            }
            userId = anonymousUserAccount.getUserId();
        }
        if (hasMobileUserAccount) {
            logger.info((Object)("Managing as MobileUserAccount: userId: [" + mobileUserAccount.getId() + "] Name: [" + mobileUserAccount.getFirstName() + " " + mobileUserAccount.getLastName() + "]"));
            String appSettingParameterNameUserId = Utilities.getMobileAppSettingParameterNameUserId(this.tenantId, this.accountId, this.pluginMap);
            logger.info((Object)("appSettingParameterNameUserId=" + appSettingParameterNameUserId));
            if (mobileUserAccount.getMobileDevices() == null || mobileUserAccount.getMobileDevices().size() == 0) {
                logger.error((Object)"MobileUserAccount does not have a MobileDevice");
                return false;
            }
            userId = Utilities.getMobileAppSettingValue(appSettingParameterNameUserId, mobileUserAccount);
            logger.info((Object)("Using userId=[" + userId + "]"));
        }
        String callbackMessage = "Task Schedule for user [" + (hasAnonymousUserAccount ? "AnonymousUserAccountId: " + anonymousUserAccount.getId() : "") + (hasMobileUserAccount ? "MobileUserAccountId: " + mobileUserAccount.getId() : "") + "]";
        logger.info((Object)("callbackMessage: [" + callbackMessage + "]"));
        int anonymousUserAccountId = anonymousUserAccount != null ? anonymousUserAccount.getId() : 0;
        int mobileUserAccountId = mobileUserAccount != null ? mobileUserAccount.getId() : 0;
        ChatbotCallback chatbotCallback = new ChatbotCallback(Integer.parseInt(this.pluginMap.get(ConstantsPlugin.BOTID)), Integer.parseInt(this.pluginMap.get(ConstantsPlugin.PLUGIN_ID)), hasAnonymousUserAccount, anonymousUserAccount, hasMobileUserAccount, mobileUserAccount, cronSchedule, callbackMessage);
        String receiptId = null;
        try {
            WebService ws = new WebService(this.pluginMap);
            receiptId = ws.registerChatbotCallback(chatbotCallback);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to register chatbot callback [" + chatbotCallback.getCallbackMessage() + "] to BBP webservices: " + e.getMessage()));
            return false;
        }
        if (receiptId == null || receiptId.length() == 0) {
            logger.error((Object)("Failed to register chatbot callback [" + chatbotCallback.getCallbackMessage() + "] to BBP webservices"));
            return false;
        }
        logger.info((Object)("Chatbot callback [" + chatbotCallback.getCallbackMessage() + "] has been registered to BBP webservices successfully. Receipt Id: [" + receiptId + "]"));
        return true;
    }

    public boolean unregisterCallbackByUser(String userId) {
        int chatbotCallbackId = 0;
        List<ChatbotTaskSchedule> chatbotTaskSchedules = this.getCallbacks();
        if (chatbotTaskSchedules != null && chatbotTaskSchedules.size() != 0) {
            for (int c = 0; c < chatbotTaskSchedules.size(); ++c) {
                String mobileUserAccountObjectUserId;
                if (chatbotTaskSchedules.get(c).hasAnonymousUserAccount() && userId == chatbotTaskSchedules.get(c).getAnonymousUserAccount().getUserId()) {
                    logger.info((Object)("Schedule found for AnonymousUserAccount -> userId [" + userId + "]"));
                    chatbotCallbackId = chatbotTaskSchedules.get(c).getId();
                    continue;
                }
                if (!chatbotTaskSchedules.get(c).hasMobileUserAccount() || userId != (mobileUserAccountObjectUserId = this.getUserIdFromChatbotTaskScheduleMobileUserAccount(chatbotTaskSchedules.get(c)))) continue;
                logger.info((Object)("Schedule found for MobileUserAccount -> userId [" + mobileUserAccountObjectUserId + "]"));
                chatbotCallbackId = chatbotTaskSchedules.get(c).getId();
            }
        }
        if (chatbotCallbackId != 0) {
            try {
                WebService ws = new WebService(this.pluginMap);
                if (!ws.unregisterChatbotCallback(chatbotCallbackId)) {
                    logger.error((Object)("Failed to unregister chatbot callback id [" + chatbotCallbackId + "] from BBP webservices"));
                    return false;
                }
                logger.info((Object)("Chatbot callback id [" + chatbotCallbackId + "] has been unregistered from BBP webservices successfully."));
            }
            catch (Exception e) {
                logger.error((Object)("Unable to unregister chatbot callback id [" + chatbotCallbackId + "] from BBP webservices: " + e.getMessage()));
                return false;
            }
        } else {
            logger.info((Object)"ChatbotCallbackId not found");
            return false;
        }
        return true;
    }

    public String getUserIdFromChatbotTaskScheduleMobileUserAccount(ChatbotTaskSchedule chatbotTaskSchedule) {
        String appSettingParameterNameUserId = Utilities.getMobileAppSettingParameterNameUserId(this.tenantId, this.accountId, this.pluginMap);
        String mobileUserAccountObjectUserId = null;
        logger.info((Object)("appSettingParameterNameUserId=" + appSettingParameterNameUserId));
        if (chatbotTaskSchedule.getMobileUserAccount().getMobileDevices() == null || chatbotTaskSchedule.getMobileUserAccount().getMobileDevices().size() == 0) {
            logger.error((Object)"MobileUserAccount does not have a MobileDevice");
            return null;
        }
        mobileUserAccountObjectUserId = Utilities.getMobileAppSettingValue(appSettingParameterNameUserId, chatbotTaskSchedule.getMobileUserAccount());
        logger.info((Object)("Returning userId [" + mobileUserAccountObjectUserId + "] from ChatbotTaskSchedule's MobileUserAccount object"));
        return mobileUserAccountObjectUserId;
    }

    public boolean unregisterCallback(int id) {
        try {
            WebService ws = new WebService(this.pluginMap);
            if (!ws.unregisterChatbotCallback(id)) {
                logger.error((Object)("Failed to unregister chatbot callback id [" + id + "] from BBP webservices"));
                return false;
            }
            logger.info((Object)("Chatbot callback id [" + id + "] has been unregistered from BBP webservices successfully."));
        }
        catch (Exception e) {
            logger.error((Object)("Unable to unregister chatbot callback id [" + id + "] from BBP webservices: " + e.getMessage()));
            return false;
        }
        return true;
    }

    public boolean unregisterAllCallbacks(MobileUserAccount mobileUserAccount) {
        List<ChatbotTaskSchedule> chatbotTaskSchedules = this.getCallbacks();
        if (chatbotTaskSchedules != null && chatbotTaskSchedules.size() != 0) {
            for (int c = 0; c < chatbotTaskSchedules.size(); ++c) {
                try {
                    WebService ws = new WebService(this.pluginMap);
                    if (!ws.unregisterChatbotCallback(chatbotTaskSchedules.get(c).getId())) {
                        logger.error((Object)("Failed to unregister chatbot callback id [" + chatbotTaskSchedules.get(c).getId() + "] from BBP webservices"));
                        return false;
                    }
                    logger.info((Object)("Chatbot callback id [" + chatbotTaskSchedules.get(c).getId() + "] has been unregistered from BBP webservices successfully."));
                    continue;
                }
                catch (Exception e) {
                    logger.error((Object)("Unable to unregister chatbot callback id [" + chatbotTaskSchedules.get(c).getId() + "] from BBP webservices: " + e.getMessage()));
                    return false;
                }
            }
        } else {
            logger.info((Object)("No chatbotTaskSchedules found for user [" + mobileUserAccount.getUsername() + "] id: [" + mobileUserAccount.getId() + "]"));
        }
        return true;
    }

    public List<ChatbotTaskSchedule> getCallbacks() {
        List<ChatbotTaskSchedule> chatbotTaskSchedules = null;
        try {
            WebService ws = new WebService(this.pluginMap);
            chatbotTaskSchedules = ws.getChatbotCallbacks();
        }
        catch (Exception e) {
            logger.error((Object)("Unable to receive chatbot callbacks from BBP webservices: " + e.getMessage()));
            return null;
        }
        if (chatbotTaskSchedules == null || chatbotTaskSchedules.size() == 0) {
            logger.info((Object)"There are no chatbot callbacks stored in BBP for this plugin");
            return chatbotTaskSchedules;
        }
        logger.info((Object)("Received chatbot callbacks [" + chatbotTaskSchedules.size() + "] from BBP webservices"));
        return chatbotTaskSchedules;
    }

    public boolean chatbotTaskScheduleExists(int id) {
        List<ChatbotTaskSchedule> chatbotTaskSchedules = null;
        try {
            WebService ws = new WebService(this.pluginMap);
            chatbotTaskSchedules = ws.getChatbotCallbacks();
        }
        catch (Exception e) {
            logger.error((Object)("Unable to receive chatbot callbacks from BBP webservices: " + e.getMessage()));
            return false;
        }
        if (chatbotTaskSchedules != null && chatbotTaskSchedules.size() != 0) {
            logger.info((Object)("Received chatbot callbacks [" + chatbotTaskSchedules.size() + "] from BBP webservices"));
            for (int c = 0; c < chatbotTaskSchedules.size(); ++c) {
                if (chatbotTaskSchedules.get(c).getId() != id) continue;
                logger.info((Object)("ChatbotTaskSchedule id [" + id + "] has been found"));
                return true;
            }
        } else {
            logger.info((Object)"There are no chatbot callbacks stored in BBP for this plugin");
            return false;
        }
        return false;
    }
}

