/*
 * Decompiled with CFR 0.152.
 */
package de.citunius.businesslogicapi.common.services;

import de.citunius.businesslogicapi.common.ConstantsPlugin;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.Template;
import freemarker.template.TemplateNotFoundException;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class TemplateService {
    static Logger logger = Logger.getLogger((String)LogManager.class.getName());
    public static Configuration freemarkerConfig = null;
    public HashMap<String, String> pluginMap = null;

    public TemplateService(HashMap<String, String> pluginMap) {
        this.pluginMap = pluginMap;
        if (freemarkerConfig == null) {
            freemarkerConfig = new Configuration();
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            String webInfPath = pluginMap.get(ConstantsPlugin.PLUGIN_SYSTEMDIR);
            String templatesPath = webInfPath + File.separator + pluginMap.get(ConstantsPlugin.PLUGIN_RESOURCE_PATH) + File.separator + "templates" + File.separator;
            logger.info((Object)("Using templatesPath: " + templatesPath));
            freemarkerConfig.setClassForTemplateLoading(classLoader.getClass(), "/");
            freemarkerConfig.setDefaultEncoding("UTF-8");
            try {
                freemarkerConfig.setDirectoryForTemplateLoading(new File(templatesPath));
            }
            catch (IOException e) {
                logger.error((Object)("templatesPath: [" + templatesPath + "]"));
                logger.error((Object)"IOException", (Throwable)e);
            }
        }
    }

    public Configuration getInstance() {
        return freemarkerConfig;
    }

    public Template getTemplate(String templateName) {
        try {
            Template freemarkerTemplate = freemarkerConfig.getTemplate(templateName + "");
            return freemarkerTemplate;
        }
        catch (TemplateNotFoundException e) {
            logger.error((Object)("TemplateNotFoundException: " + e.getMessage() + " Template path: [/resources/templates/" + templateName + "]"));
            logger.error((Object)e);
        }
        catch (MalformedTemplateNameException e) {
            logger.error((Object)("MalformedTemplateNameException: " + e.getMessage()));
            logger.error((Object)e);
        }
        catch (ParseException e) {
            logger.error((Object)("ParseException: " + e.getMessage()));
            logger.error((Object)e);
        }
        catch (IOException e) {
            logger.error((Object)("IOException: " + e.getMessage()));
            logger.error((Object)e);
        }
        return null;
    }
}

