/*
 * Decompiled with CFR 0.152.
 */
package com.rivescript;

import com.rivescript.ConcatMode;
import com.rivescript.session.SessionManager;
import java.util.HashMap;
import java.util.Map;

public class Config {
    public static final ConcatMode DEFAULT_CONCAT = ConcatMode.NONE;
    public static final int DEFAULT_DEPTH = 50;
    public static final String DEFAULT_UNICODE_PUNCTUATION_PATTERN = "[.,!?;:]";
    private boolean throwExceptions;
    private boolean strict;
    private boolean utf8;
    private String unicodePunctuation = "[.,!?;:]";
    private boolean forceCase;
    private ConcatMode concat = DEFAULT_CONCAT;
    private int depth = 50;
    private SessionManager sessionManager;
    private Map<String, String> errorMessages;

    protected Config() {
    }

    public boolean isThrowExceptions() {
        return this.throwExceptions;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public boolean isUtf8() {
        return this.utf8;
    }

    public String getUnicodePunctuation() {
        return this.unicodePunctuation;
    }

    public boolean isForceCase() {
        return this.forceCase;
    }

    public ConcatMode getConcat() {
        return this.concat;
    }

    public int getDepth() {
        return this.depth;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public Map<String, String> getErrorMessages() {
        return this.errorMessages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Config that = (Config)o;
        if (this.throwExceptions != that.throwExceptions) {
            return false;
        }
        if (this.strict != that.strict) {
            return false;
        }
        if (this.utf8 != that.utf8) {
            return false;
        }
        if (this.forceCase != that.forceCase) {
            return false;
        }
        if (this.concat != that.concat) {
            return false;
        }
        if (this.depth != that.depth) {
            return false;
        }
        if (this.unicodePunctuation != null ? !this.unicodePunctuation.equals(that.unicodePunctuation) : that.unicodePunctuation != null) {
            return false;
        }
        if (this.sessionManager != null ? !this.sessionManager.equals(that.sessionManager) : that.sessionManager != null) {
            return false;
        }
        return this.errorMessages != null ? this.errorMessages.equals(that.errorMessages) : that.errorMessages == null;
    }

    public int hashCode() {
        int result = this.throwExceptions ? 1 : 0;
        result = 31 * result + (this.strict ? 1 : 0);
        result = 31 * result + (this.utf8 ? 1 : 0);
        result = 31 * result + (this.unicodePunctuation != null ? this.unicodePunctuation.hashCode() : 0);
        result = 31 * result + (this.forceCase ? 1 : 0);
        result = 31 * result + (this.concat != null ? this.concat.hashCode() : 0);
        result = 31 * result + this.depth;
        result = 31 * result + (this.sessionManager != null ? this.sessionManager.hashCode() : 0);
        result = 31 * result + (this.errorMessages != null ? this.errorMessages.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Config{throwExceptions=" + this.throwExceptions + ", strict=" + this.strict + ", utf8=" + this.utf8 + ", unicodePunctuation='" + this.unicodePunctuation + '\'' + ", forceCase=" + this.forceCase + ", concat=" + (Object)((Object)this.concat) + ", depth=" + this.depth + ", sessionManager=" + this.sessionManager + ", errorMessages=" + this.errorMessages + '}';
    }

    public Builder toBuilder() {
        return Config.newBuilder().throwExceptions(this.throwExceptions).strict(this.strict).utf8(this.utf8).unicodePunctuation(this.unicodePunctuation).forceCase(this.forceCase).concat(this.concat).depth(this.depth).sessionManager(this.sessionManager).errorMessages(this.errorMessages);
    }

    public static Config basic() {
        return Builder.basic().build();
    }

    public static Config utf8() {
        return Builder.utf8().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private boolean throwExceptions;
        private boolean strict;
        private boolean utf8;
        private String unicodePunctuation = "[.,!?;:]";
        private boolean forceCase;
        private ConcatMode concat = DEFAULT_CONCAT;
        private int depth = 50;
        private SessionManager sessionManager;
        private Map<String, String> errorMessages;

        private Builder() {
        }

        public Builder throwExceptions(boolean throwExceptions) {
            this.throwExceptions = throwExceptions;
            return this;
        }

        public Builder strict(boolean strict) {
            this.strict = strict;
            return this;
        }

        public Builder utf8(boolean utf8) {
            this.utf8 = utf8;
            return this;
        }

        public Builder unicodePunctuation(String unicodePunctuation) {
            this.unicodePunctuation = unicodePunctuation;
            return this;
        }

        public Builder forceCase(boolean forceCase) {
            this.forceCase = forceCase;
            return this;
        }

        public Builder concat(ConcatMode concat) {
            this.concat = concat;
            return this;
        }

        public Builder depth(int depth) {
            this.depth = depth;
            return this;
        }

        public Builder sessionManager(SessionManager sessionManager) {
            this.sessionManager = sessionManager;
            return this;
        }

        public Builder errorMessages(Map<String, String> errorMessages) {
            this.errorMessages = errorMessages;
            return this;
        }

        public Builder addErrorMessage(String key, String value) {
            if (this.errorMessages == null) {
                this.errorMessages = new HashMap<String, String>();
            }
            this.errorMessages.put(key, value);
            return this;
        }

        public Config build() {
            Config config = new Config();
            config.throwExceptions = this.throwExceptions;
            config.strict = this.strict;
            config.utf8 = this.utf8;
            config.unicodePunctuation = this.unicodePunctuation;
            config.forceCase = this.forceCase;
            config.concat = this.concat;
            config.depth = this.depth;
            config.sessionManager = this.sessionManager;
            config.errorMessages = this.errorMessages;
            return config;
        }

        public static Builder basic() {
            return new Builder().strict(true);
        }

        public static Builder utf8() {
            return Builder.basic().utf8(true);
        }
    }
}

