/*
 * Decompiled with CFR 0.152.
 */
package com.rivescript.lang;

import com.rivescript.RiveScript;
import com.rivescript.macro.ObjectHandler;
import com.rivescript.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Vector;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Perl
implements ObjectHandler {
    private static Logger logger = LoggerFactory.getLogger(Perl.class);
    private String rsp4j;
    private HashMap<String, String> codes;

    public Perl(String rsp4j) {
        this.rsp4j = Objects.requireNonNull(rsp4j, "'rsp4j' must not be null");
        this.codes = new HashMap();
    }

    @Override
    public void load(RiveScript rs, String name, String[] code) {
        this.codes.put(name, StringUtils.join(code, "\n"));
    }

    @Override
    public String call(RiveScript rs, String name, String[] fields) {
        String user = rs.currentUser();
        try {
            String incoming;
            JSONObject json = new JSONObject();
            json.put("id", (Object)user);
            json.put("message", (Object)StringUtils.join(fields, " "));
            json.put("code", (Object)this.codes.get(name));
            JSONObject vars = new JSONObject();
            Map<String, String> data = rs.getUservars(user).getVariables();
            Iterator<String> it = data.keySet().iterator();
            while (it.hasNext()) {
                String key = it.next().toString();
                vars.put(key, (Object)data.get(key));
            }
            json.put("vars", (Object)vars);
            String outgoing = json.toString();
            try {
                String line;
                Process p = Runtime.getRuntime().exec(this.rsp4j + " --java");
                OutputStream stdIn = p.getOutputStream();
                BufferedReader stdOut = new BufferedReader(new InputStreamReader(p.getInputStream()));
                stdIn.write(outgoing.getBytes());
                stdIn.flush();
                stdIn.close();
                Vector<String> result = new Vector<String>();
                while ((line = stdOut.readLine()) != null) {
                    result.add(line);
                }
                incoming = StringUtils.join(result.toArray(new String[0]), "\n");
            }
            catch (IOException e) {
                logger.error("IOException error in " + this.getClass().getCanonicalName() + ": " + e.getMessage());
                return "[ERR: IOException: " + e.getMessage() + "]";
            }
            JSONObject reply = new JSONObject(incoming);
            if (reply.getString("status").equals("error")) {
                return "[ERR: " + reply.getString("message");
            }
            JSONObject newVars = reply.getJSONObject("vars");
            String[] keys = JSONObject.getNames((JSONObject)newVars);
            for (int i = 0; i < keys.length; ++i) {
                String value = newVars.getString(keys[i]);
                rs.setUservar(user, keys[i], value);
            }
            return reply.getString("reply");
        }
        catch (JSONException e) {
            logger.error("JSONException in " + this.getClass().getCanonicalName() + ": " + e.getMessage());
            return "[ERR: JSONException: " + e.getMessage() + "]";
        }
    }
}

