/*
 * Decompiled with CFR 0.152.
 */
package com.rivescript.lang.jsr223;

import com.rivescript.RiveScript;
import com.rivescript.macro.ObjectHandler;
import com.rivescript.util.StringUtils;
import java.util.Objects;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Jsr223ScriptingHandler
implements ObjectHandler {
    private static Logger logger = LoggerFactory.getLogger(Jsr223ScriptingHandler.class);
    protected String engineName;
    protected ScriptEngine scriptEngine;
    protected String functionNamePrefix;
    protected String functionCodeFormat;
    protected String codeDelimiter;

    public Jsr223ScriptingHandler(String engineName, String functionCodeFormat) {
        this(engineName, functionCodeFormat, "object_");
    }

    public Jsr223ScriptingHandler(String engineName, String functionCodeFormat, String functionNamePrefix) {
        this(engineName, functionCodeFormat, functionNamePrefix, "\n");
    }

    public Jsr223ScriptingHandler(String engineName, String functionCodeFormat, String functionNamePrefix, String codeDelimiter) {
        this.engineName = Objects.requireNonNull(engineName, "'engineName' must not be null");
        this.functionNamePrefix = Objects.requireNonNull(functionNamePrefix, "'functionNamePrefix' must not be null");
        this.functionCodeFormat = Objects.requireNonNull(functionCodeFormat, "'functionCodeFormat' must not be null");
        this.codeDelimiter = Objects.requireNonNull(codeDelimiter, "'codeDelimiter' must not be null");
        this.scriptEngine = new ScriptEngineManager().getEngineByName(engineName);
        if (this.scriptEngine == null) {
            this.scriptEngine = new ScriptEngineManager(null).getEngineByName(engineName);
            if (this.scriptEngine == null) {
                logger.error("No script engine found for '{}'", (Object)engineName);
            }
        }
    }

    @Override
    public void load(RiveScript rs, String name, String[] code) {
        if (this.scriptEngine == null) {
            logger.warn("Cannot load macro '{}' as no script engine was found for '{}'", (Object)name, (Object)this.engineName);
        } else {
            long startTime = System.currentTimeMillis();
            String function = this.resolveFunctionCode(name, code);
            try {
                this.scriptEngine.eval(function);
                if (logger.isDebugEnabled()) {
                    long elapsedTime = System.currentTimeMillis() - startTime;
                    logger.debug("Loaded code for macro '{}' in {} ms", (Object)name, (Object)elapsedTime);
                }
            }
            catch (ScriptException e) {
                logger.error("Error loading code for marco '{}'", (Object)name, (Object)e);
            }
        }
    }

    @Override
    public String call(RiveScript rs, String name, String[] fields) {
        String result = null;
        if (this.scriptEngine == null) {
            logger.warn("Cannot call macro '{}' as no script engine was found for '{}'", (Object)name, (Object)this.engineName);
        } else {
            long startTime = System.currentTimeMillis();
            try {
                Invocable invocable = (Invocable)((Object)this.scriptEngine);
                Object value = invocable.invokeFunction(this.resolveFunctionName(name), rs, fields);
                if (value != null) {
                    result = value.toString();
                }
                if (logger.isDebugEnabled()) {
                    long elapsedTime = System.currentTimeMillis() - startTime;
                    if (result == null) {
                        logger.debug("Returned null from macro '{}' in {} ms", (Object)name, (Object)elapsedTime);
                    } else {
                        logger.debug("Returned '{}' from macro '{}' in {} ms", new Object[]{result, name, elapsedTime});
                    }
                }
            }
            catch (ScriptException e) {
                logger.error("Error invoking function for macro '{}'", (Object)name, (Object)e);
            }
            catch (NoSuchMethodException e) {
                logger.error("Error invoking function for macro '{}'", (Object)name, (Object)e);
            }
        }
        return result;
    }

    protected String resolveFunctionName(String name) {
        return this.functionNamePrefix + name;
    }

    protected String resolveFunctionCode(String name, String[] code) {
        return String.format(this.functionCodeFormat, this.resolveFunctionName(name), StringUtils.join(code, this.codeDelimiter));
    }
}

