/*
 * Decompiled with CFR 0.152.
 */
package com.rivescript.session;

import com.rivescript.session.History;
import com.rivescript.session.SessionManager;
import com.rivescript.session.ThawAction;
import com.rivescript.session.UserData;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ConcurrentHashMapSessionManager
implements SessionManager {
    private ConcurrentHashMap<String, UserData> users = new ConcurrentHashMap();
    private ConcurrentHashMap<String, UserData> frozen = new ConcurrentHashMap();

    @Override
    public UserData init(String username) {
        if (!this.users.containsKey(username)) {
            this.users.put(username, this.defaultSession());
        }
        return this.users.get(username);
    }

    @Override
    public void set(String username, String name, String value) {
        UserData userData = this.init(username);
        userData.setVariable(name, value);
    }

    @Override
    public void set(String username, Map<String, String> vars) {
        UserData userData = this.init(username);
        for (Map.Entry<String, String> var : vars.entrySet()) {
            userData.setVariable(var.getKey(), var.getValue());
        }
    }

    @Override
    public void addHistory(String username, String input, String reply) {
        UserData userData = this.init(username);
        Collections.rotate(userData.getHistory().getInput(), 1);
        userData.getHistory().getInput().set(0, input.trim());
        Collections.rotate(userData.getHistory().getReply(), 1);
        userData.getHistory().getReply().set(0, reply.trim());
    }

    @Override
    public void setLastMatch(String username, String trigger) {
        UserData userData = this.init(username);
        userData.setLastMatch(trigger);
    }

    @Override
    public String get(String username, String name) {
        if (!this.users.containsKey(username)) {
            return null;
        }
        return this.users.get(username).getVariable(name);
    }

    @Override
    public UserData get(String username) {
        if (!this.users.containsKey(username)) {
            return null;
        }
        return this.users.get(username);
    }

    @Override
    public Map<String, UserData> getAll() {
        return this.users;
    }

    @Override
    public String getLastMatch(String username) {
        if (!this.users.containsKey(username)) {
            return null;
        }
        return this.users.get(username).getLastMatch();
    }

    @Override
    public History getHistory(String username) {
        if (!this.users.containsKey(username)) {
            return null;
        }
        return this.users.get(username).getHistory();
    }

    @Override
    public void clear(String username) {
        this.users.remove(username);
        this.frozen.remove(username);
    }

    @Override
    public void clearAll() {
        this.users.clear();
        this.frozen.clear();
    }

    @Override
    public void freeze(String username) {
        if (this.users.containsKey(username)) {
            UserData data = this.users.get(username);
            this.frozen.put(username, this.cloneUser(data));
        }
    }

    @Override
    public void thaw(String username, ThawAction action) {
        if (this.frozen.containsKey(username)) {
            UserData frozen = this.frozen.get(username);
            if (action == ThawAction.THAW) {
                this.users.put(username, this.cloneUser(frozen));
                this.frozen.remove(username);
            } else if (action == ThawAction.DISCARD) {
                this.frozen.remove(username);
            } else if (action == ThawAction.KEEP) {
                this.users.put(username, this.cloneUser(frozen));
            }
        }
    }

    private UserData cloneUser(UserData data) {
        UserData clone = this.defaultSession();
        for (Map.Entry<String, String> entry : data.getVariables().entrySet()) {
            clone.setVariable(entry.getKey(), entry.getValue());
        }
        for (int i = 0; i < 9; ++i) {
            clone.getHistory().getInput().set(i, data.getHistory().getInput(i));
            clone.getHistory().getReply().set(i, data.getHistory().getReply(i));
        }
        return clone;
    }

    private UserData defaultSession() {
        UserData userData = new UserData();
        userData.setVariable("topic", "random");
        userData.setLastMatch("");
        return userData;
    }
}

