/*
 * Decompiled with CFR 0.152.
 */
package de.citunius.bbp.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.citunius.bbp.objects.MobileAppSetting;
import de.citunius.bbp.objects.MobileDevice;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class MobileApp {
    static Logger logger = Logger.getLogger((String)LogManager.class.getName());
    public static final String TENANTID_FIELD = "tenant_id";
    @JsonProperty(value="tenant_id")
    String tenantId;
    public static final String ACCOUNTID_FIELD = "account_id";
    @JsonProperty(value="account_id")
    String accountId;
    public static final String ID_FIELD = "id";
    @JsonProperty(value="id")
    int id;
    public static final String ISPRIMARYAPP_FIELD = "isprimaryapp";
    @JsonProperty(value="isprimaryapp")
    boolean isPrimaryApp;
    public static final String APPNAME_FIELD = "appname";
    @JsonProperty(value="appname")
    String appName;
    public static final String APPPROVIDER_FIELD = "appprovider";
    @JsonProperty(value="appprovider")
    String appProvider;
    public static final String MOBILEDEVICE_FIELD = "mobiledevice";
    @JsonProperty(value="mobiledevice")
    MobileDevice mobileDevice;
    public static final String MOBILEAPPSETTINGS_FIELD = "mobileappsettings";
    @JsonProperty(value="mobileappsettings")
    List<MobileAppSetting> mobileAppSettings;

    public MobileApp() {
    }

    public MobileApp(JSONObject jsonObject) {
        if (jsonObject.has(TENANTID_FIELD) && !jsonObject.isNull(TENANTID_FIELD)) {
            this.tenantId = jsonObject.getString(TENANTID_FIELD);
        }
        if (jsonObject.has(ACCOUNTID_FIELD) && !jsonObject.isNull(ACCOUNTID_FIELD)) {
            this.accountId = jsonObject.getString(ACCOUNTID_FIELD);
        }
        if (jsonObject.has(ID_FIELD) && !jsonObject.isNull(ID_FIELD)) {
            this.id = jsonObject.getInt(ID_FIELD);
        }
        if (jsonObject.has(ISPRIMARYAPP_FIELD) && !jsonObject.isNull(ISPRIMARYAPP_FIELD)) {
            this.isPrimaryApp = jsonObject.getBoolean(ISPRIMARYAPP_FIELD);
        }
        if (jsonObject.has(APPNAME_FIELD) && !jsonObject.isNull(APPNAME_FIELD)) {
            this.appName = jsonObject.getString(APPNAME_FIELD);
        }
        if (jsonObject.has(APPPROVIDER_FIELD) && !jsonObject.isNull(APPPROVIDER_FIELD)) {
            this.appProvider = jsonObject.getString(APPPROVIDER_FIELD);
        }
        if (jsonObject.has(MOBILEDEVICE_FIELD) && !jsonObject.isNull(MOBILEDEVICE_FIELD)) {
            this.mobileDevice = new MobileDevice(jsonObject.getJSONObject(MOBILEDEVICE_FIELD));
        }
        if (jsonObject.has(MOBILEAPPSETTINGS_FIELD) && !jsonObject.isNull(MOBILEAPPSETTINGS_FIELD)) {
            this.mobileAppSettings = new ArrayList<MobileAppSetting>();
            JSONArray mobileAppSettings = jsonObject.getJSONArray(MOBILEAPPSETTINGS_FIELD);
            for (int i = 0; i < mobileAppSettings.length(); ++i) {
                this.mobileAppSettings.add(new MobileAppSetting(mobileAppSettings.getJSONObject(i)));
            }
        } else {
            logger.error((Object)("MobileApp [" + this.id + "] has no mobile app settings defined!"));
        }
    }

    public MobileApp(String tenantId, String accountId, int id, boolean isPrimaryApp, String appName, String appProvider, MobileDevice mobileDevice, List<MobileAppSetting> mobileAppSettings) {
        this.tenantId = tenantId;
        this.accountId = accountId;
        this.id = id;
        this.isPrimaryApp = isPrimaryApp;
        this.appName = appName;
        this.appProvider = appProvider;
        this.mobileDevice = mobileDevice;
        this.mobileAppSettings = mobileAppSettings;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int newId) {
        this.id = newId;
    }

    public boolean getIsPrimaryApp() {
        return this.isPrimaryApp;
    }

    public void setIsPrimaryApp(boolean isPrimaryApp) {
        this.isPrimaryApp = isPrimaryApp;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppProvider() {
        return this.appProvider;
    }

    public void setAppProvider(String appProvider) {
        this.appProvider = appProvider;
    }

    public MobileDevice getMobileDevice() {
        return this.mobileDevice;
    }

    public void setMobileDevice(MobileDevice mobileDevice) {
        this.mobileDevice = mobileDevice;
    }

    public List<MobileAppSetting> getMobileAppSettings() {
        return this.mobileAppSettings;
    }

    public void setMobileAppSettings(List<MobileAppSetting> mobileAppSettings) {
        this.mobileAppSettings = mobileAppSettings;
    }

    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        if (this.tenantId != null) {
            jsonObject.put(TENANTID_FIELD, (Object)this.tenantId);
        }
        if (this.accountId != null) {
            jsonObject.put(ACCOUNTID_FIELD, (Object)this.accountId);
        }
        jsonObject.put(ID_FIELD, this.id);
        jsonObject.put(ISPRIMARYAPP_FIELD, this.isPrimaryApp);
        if (this.appName != null) {
            jsonObject.put(APPNAME_FIELD, (Object)this.appName);
        }
        if (this.appProvider != null) {
            jsonObject.put(APPPROVIDER_FIELD, (Object)this.appProvider);
        }
        if (this.mobileDevice != null) {
            jsonObject.put(MOBILEDEVICE_FIELD, (Object)this.mobileDevice.toJson());
        }
        if (this.mobileAppSettings != null) {
            JSONArray mobileAppSettingsJsonArray = new JSONArray();
            for (int i = 0; i < this.mobileAppSettings.size(); ++i) {
                mobileAppSettingsJsonArray.put((Object)this.mobileAppSettings.get(i).toJson());
            }
            jsonObject.put(MOBILEAPPSETTINGS_FIELD, (Object)mobileAppSettingsJsonArray);
        }
        return jsonObject;
    }

    public String toString() {
        return "MobileApp [tenantId=" + this.tenantId + ", accountId=" + this.accountId + ", id=" + this.id + ", isPrimaryApp=" + this.isPrimaryApp + ", appName=" + this.appName + ", appProvider=" + this.appProvider + ", mobileDevice=" + this.mobileDevice + ", mobileAppSettings=" + this.mobileAppSettings + "]";
    }
}

