/*
 * Decompiled with CFR 0.152.
 */
package de.citunius.businesslogicapi.common.database;

import de.citunius.businesslogicapi.common.Utilities;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class DatabaseConnection {
    static Logger logger = Logger.getLogger((String)LogManager.class.getName());
    private Connection currentConection;
    HashMap<String, String> pluginMap = null;

    public DatabaseConnection(HashMap<String, String> pluginMap) {
        this.pluginMap = pluginMap;
        this.currentConection = this.openConnection();
    }

    private Connection openConnection() {
        Connection connection = null;
        logger.debug((Object)("Using Database.MySQL.Driver.Class: [" + Utilities.getAttributeFromPropertiesFile(this.pluginMap, "Database.MySQL.Driver.Class") + "]"));
        logger.debug((Object)("Using Database.MySQL.URL.MMG: [" + Utilities.getAttributeFromPropertiesFile(this.pluginMap, "Database.MySQL.URL") + "]"));
        logger.debug((Object)("Using Database.MySQL.Username: [" + Utilities.getAttributeFromPropertiesFile(this.pluginMap, "Database.MySQL.Username") + "]"));
        logger.debug((Object)("Using Database.MySQL.Password: [" + Utilities.getAttributeFromPropertiesFile(this.pluginMap, "Database.MySQL.Password") + "]"));
        logger.debug((Object)"Opening connection to database...");
        try {
            Class.forName(Utilities.getAttributeFromPropertiesFile(this.pluginMap, "Database.MySQL.Driver.Class")).newInstance();
            connection = DriverManager.getConnection(Utilities.getAttributeFromPropertiesFile(this.pluginMap, "Database.MySQL.URL"), Utilities.getAttributeFromPropertiesFile(this.pluginMap, "Database.MySQL.Username"), Utilities.getAttributeFromPropertiesFile(this.pluginMap, "Database.MySQL.Password"));
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | SQLException e) {
            System.err.println(e);
            logger.error((Object)e);
        }
        return connection;
    }

    public void closeConnection() {
        try {
            this.currentConection.close();
        }
        catch (SQLException e) {
            logger.error((Object)("SQLException: " + e.getMessage()));
            logger.error((Object)e);
        }
    }

    public ResultSet runSqlQuery(String query) throws SQLException {
        Statement statement = this.currentConection.createStatement();
        return statement.executeQuery(query);
    }

    public Boolean executeQuery_NOTUSED(String query) throws SQLException {
        Statement statement = this.currentConection.createStatement();
        return statement.execute(query);
    }

    public PreparedStatement getPreparedStatement(String query) throws SQLException {
        return this.currentConection.prepareStatement(query);
    }

    public PreparedStatement getPreparedStatement(String query, int flags) throws SQLException {
        return this.currentConection.prepareStatement(query, flags);
    }

    public String getDatamodelVersion_NOTUSED() {
        return null;
    }

    public void initTransaction() throws SQLException {
        this.currentConection.setAutoCommit(false);
    }

    public void commitTransaction() throws SQLException {
        try {
            this.currentConection.commit();
        }
        catch (SQLException e) {
            if (this.currentConection != null) {
                this.currentConection.rollback();
            }
        }
        finally {
            this.currentConection.setAutoCommit(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[][] getResultsFromDatabase(String query) {
        logger.trace((Object)"Entering method");
        if (query == null || query.length() == 0) {
            logger.error((Object)"Database query can not be empty");
            return null;
        }
        if (this.currentConection == null) {
            logger.error((Object)"No connection to database");
            return null;
        }
        try {
            Statement stmt = this.currentConection.createStatement();
            ResultSet rs = stmt.executeQuery(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            ArrayList<String[]> rows = new ArrayList<String[]>();
            while (true) {
                if (!rs.next()) {
                    String[][] rowData = (String[][])rows.toArray((T[])new String[rows.size()][columnCount]);
                    rs.close();
                    stmt.close();
                    return rowData;
                }
                String[] row = new String[columnCount];
                for (int i = 1; i <= columnCount; ++i) {
                    row[i - 1] = rs.getString(i);
                }
                rows.add(row);
            }
        }
        catch (SQLException e) {
            logger.fatal((Object)("SQLException: [" + e.getMessage() + "]"));
            logger.fatal((Object)("SQLException: " + e));
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            logger.fatal((Object)("Exception: [" + e.getMessage() + "]"));
            logger.fatal((Object)("Exception: " + e));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[][] executeQuery(String query) {
        Statement stmt = null;
        ResultSet result = null;
        try {
            stmt = this.currentConection.createStatement();
            PreparedStatement preparedStatement = this.getPreparedStatement(query);
            result = preparedStatement.executeQuery(query);
            ResultSetMetaData rsmd = result.getMetaData();
            int columnCount = rsmd.getColumnCount();
            ArrayList<String[]> rows = new ArrayList<String[]>();
            while (result.next()) {
                String[] row = new String[columnCount];
                for (int i = 1; i <= columnCount; ++i) {
                    row[i - 1] = result.getString(i);
                }
                rows.add(row);
            }
            String[][] rowData = (String[][])rows.toArray((T[])new String[rows.size()][columnCount]);
            result.close();
            stmt.close();
            String[][] stringArray = rowData;
            return stringArray;
        }
        catch (SQLException e) {
            logger.fatal((Object)("SQLException: " + e.getMessage() + "]"));
            logger.fatal((Object)("Failed query: [" + query + "]"));
            logger.fatal((Object)("SQLException: " + e));
            e.printStackTrace();
        }
        catch (Exception e) {
            logger.fatal((Object)("Exception: " + e.getMessage() + "]"));
            logger.fatal((Object)("Failed query: [" + query + "]"));
            logger.error((Object)("Exception: " + e));
            e.printStackTrace();
        }
        finally {
            if (result != null) {
                try {
                    result.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeQueryUpdate(String query) {
        int rowUpdate = -1;
        int rowId = -1;
        Statement stmt = null;
        Statement preparedStatement = null;
        try {
            stmt = this.currentConection.createStatement();
            preparedStatement = this.getPreparedStatement(query);
            if (query.startsWith("INSERT")) {
                preparedStatement.executeUpdate(query, 1);
                ResultSet rs = preparedStatement.getGeneratedKeys();
                if (rs.next()) {
                    rowId = rs.getInt(1);
                }
                if (rowId > 0) {
                    logger.debug((Object)("Query OK: rowId: [" + rowId + "] [" + query + "]"));
                } else {
                    logger.fatal((Object)("Query failed: rowId: [" + rowId + "] [" + query + "]"));
                }
                int n = rowId;
                return n;
            }
            rowUpdate = preparedStatement.executeUpdate(query, 1);
            if (rowUpdate > 0) {
                logger.debug((Object)("Query OK: rowId: [" + rowUpdate + "] [" + query + "]"));
            } else {
                logger.fatal((Object)("Query failed: rowId: [" + rowUpdate + "] [" + query + "]"));
            }
            int rs = rowUpdate;
            return rs;
        }
        catch (SQLException e) {
            logger.fatal((Object)("SQLException: " + e.getMessage() + "]"));
            logger.fatal((Object)("Failed query: [" + query + "]"));
            logger.fatal((Object)("SQLException: " + e));
            e.printStackTrace();
        }
        catch (Exception e) {
            logger.fatal((Object)("Exception: " + e.getMessage() + "]"));
            logger.fatal((Object)("Failed query: [" + query + "]"));
            logger.error((Object)("Exception: " + e));
            e.printStackTrace();
        }
        finally {
            if (preparedStatement != null) {
                try {
                    preparedStatement.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)e);
                }
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCountFromDatabase(String query) {
        logger.trace((Object)"Entering method");
        ResultSet rs = null;
        Statement stmt = null;
        int DBRowCount = 0;
        if (query == null || query.length() == 0) {
            logger.error((Object)"Database query can not be empty");
            return -1;
        }
        if (this.currentConection == null) {
            logger.error((Object)"No connection to database");
            return -1;
        }
        try {
            stmt = this.currentConection.createStatement();
            rs = stmt.executeQuery(query);
            rs.last();
            DBRowCount = rs.getRow();
        }
        catch (SQLException e) {
            logger.fatal((Object)"SQLException", (Throwable)e);
            while (e != null) {
                e = e.getNextException();
            }
        }
        catch (Exception e) {
            logger.debug((Object)"Exception", (Throwable)e);
            int n = -1;
            return n;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("SQLException: " + e));
                }
            }
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.error((Object)("SQLException: " + e));
                }
            }
        }
        return DBRowCount;
    }
}

