/*
 * Decompiled with CFR 0.152.
 */
package de.citunius.businesslogicapi.common.services;

import de.citunius.businesslogicapi.common.ConstantsPlugin;
import de.citunius.businesslogicapi.common.OSValidator;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class LocalisationService {
    static Logger logger = Logger.getLogger((String)LogManager.class.getName());
    private static HashMap<String, LocalisationService> instances = null;
    private static final HashMap<String, String> supportedLanguages = new HashMap();
    public HashMap<String, String> pluginMap = null;
    private ResourceBundle english;
    private ResourceBundle spanish;
    private ResourceBundle dutch;
    private ResourceBundle german;
    private ResourceBundle italian;
    private ResourceBundle french;
    private ResourceBundle malayalam;
    private ResourceBundle hindi;
    private ResourceBundle portuguese;
    private ResourceBundle portuguesebr;
    private ResourceBundle russian;
    private ResourceBundle arabic;
    private ResourceBundle catalan;
    private ResourceBundle galician;
    private ResourceBundle persian;
    private ResourceBundle turkish;

    public LocalisationService(HashMap<String, String> pluginMap) {
        this.pluginMap = pluginMap;
        try {
            String webInfPath = null;
            if (OSValidator.isUnix()) {
                webInfPath = "file://" + pluginMap.get(ConstantsPlugin.PLUGIN_SYSTEMDIR).replace("\\", "/");
            } else if (OSValidator.isWindows()) {
                webInfPath = "file:/" + pluginMap.get(ConstantsPlugin.PLUGIN_SYSTEMDIR).replace("\\", "/");
            } else {
                logger.error((Object)("Unsupported operating system: [" + OSValidator.getOS() + "]"));
                return;
            }
            String localizationPath = webInfPath + "/" + pluginMap.get(ConstantsPlugin.PLUGIN_RESOURCE_PATH) + "/localization/";
            logger.info((Object)("urls: " + localizationPath));
            URL[] urls = new URL[]{new URL(localizationPath)};
            URLClassLoader loader = new URLClassLoader(urls);
            this.english = ResourceBundle.getBundle("strings", new Locale("en", "US"), loader);
            supportedLanguages.put("en", "English");
            this.german = ResourceBundle.getBundle("strings", new Locale("de", "DE"), loader);
            supportedLanguages.put("de", "Deutsch");
        }
        catch (MissingResourceException e) {
            logger.error((Object)"MissingResourceException", (Throwable)e);
        }
        catch (MalformedURLException e) {
            logger.error((Object)"MalformedURLException", (Throwable)e);
        }
    }

    public String getString(String key) {
        String result;
        try {
            result = this.english.getString(key);
        }
        catch (MissingResourceException e) {
            result = "String not found";
        }
        return result;
    }

    public String getString(String key, String language) {
        String result;
        if (key == null || key.length() == 0 || language == null || language.length() == 0) {
            logger.error((Object)("Invalid String label request: key: [" + key + "] language: [" + language + "]"));
            return null;
        }
        try {
            switch (language.toLowerCase()) {
                case "en": {
                    result = this.english.getString(key);
                    break;
                }
                case "de": {
                    result = this.german.getString(key);
                    break;
                }
                default: {
                    result = this.english.getString(key);
                    break;
                }
            }
        }
        catch (MissingResourceException e) {
            logger.warn((Object)("Missing language resource for label Key:[" + key + "] Language:[" + language + "]"));
            result = "[" + key + "]";
        }
        logger.trace((Object)("Return language label [" + result + "] for Key:[" + key + "] Language:[" + language + "]"));
        return result;
    }

    public HashMap<String, String> getSupportedLanguages() {
        return supportedLanguages;
    }

    public static <T, E> String getLanguageCodeByName(E value) {
        for (Map.Entry<String, String> entry : supportedLanguages.entrySet()) {
            if (!Objects.equals(value, entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean isLanguageCodeSupported(String languageCode) {
        if (supportedLanguages != null && supportedLanguages.size() != 0) {
            return supportedLanguages.containsKey(languageCode);
        }
        return false;
    }

    private class CustomClassLoader
    extends ClassLoader {
        public CustomClassLoader(ClassLoader parent) {
            super(parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InputStream getResourceAsStream(String name) {
            InputStream utf8in = this.getParent().getResourceAsStream(name);
            if (utf8in != null) {
                try {
                    byte[] utf8Bytes = new byte[utf8in.available()];
                    utf8in.read(utf8Bytes, 0, utf8Bytes.length);
                    byte[] iso8859Bytes = new String(utf8Bytes, "UTF-8").getBytes("ISO-8859-1");
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(iso8859Bytes);
                    return byteArrayInputStream;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    try {
                        utf8in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            return null;
        }
    }
}

