/*
 * Decompiled with CFR 0.152.
 */
package de.citunius.businesslogicapi.common.services;

import de.citunius.bbp.objects.ChatbotCallback;
import de.citunius.bbp.objects.ChatbotTaskSchedule;
import de.citunius.bbp.objects.Userstate;
import de.citunius.businesslogicapi.common.ConstantsPlugin;
import de.citunius.businesslogicapi.common.Utilities;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class WebService {
    static Logger logger = Logger.getLogger((String)LogManager.class.getName());
    public HashMap<String, String> pluginMap = null;

    public WebService(HashMap<String, String> pluginMap) {
        this.pluginMap = pluginMap;
    }

    public boolean setUserstate(Userstate userstate) {
        String bbpWebservicesBaseUrl = this.pluginMap.get(ConstantsPlugin.BBP_WEBSERVICES_URL);
        String tenantId = this.pluginMap.get(ConstantsPlugin.TENANTID);
        String apiId = Utilities.getAttributeFromPropertiesFile(this.pluginMap, "BusinessBotPlatform.Account.ApiId");
        String apiKey = Utilities.getAttributeFromPropertiesFile(this.pluginMap, "BusinessBotPlatform.Account.ApiKey");
        String url = bbpWebservicesBaseUrl + tenantId + ":" + apiId + ":" + apiKey + "/setUserstate";
        logger.info((Object)("Url: [" + url + "]"));
        String responseContent = WebService.sendHttpPostRequest(url, userstate.toJson().toString());
        logger.info((Object)("Response from BBP: [" + responseContent + "]"));
        if (responseContent != null) {
            JSONObject result = new JSONObject(responseContent);
            try {
                int statusCode = result.getInt("code");
                if (statusCode == 200) {
                    return true;
                }
                logger.error((Object)("BBP returned statusCode: [" + statusCode + "] desc: [" + result.getString("description") + "]"));
                return false;
            }
            catch (Exception e) {
                logger.error((Object)("Can not parse JSON return message from BBP: responseContent: [" + responseContent + "]"));
                logger.error((Object)("Exception: " + e));
            }
        } else {
            logger.error((Object)("Unexpected response from BBP webservice: [" + responseContent + "]"));
            return false;
        }
        return false;
    }

    public String registerChatbotCallback(ChatbotCallback chatbotCallback) throws Exception {
        String bbpWebservicesBaseUrl = this.pluginMap.get(ConstantsPlugin.BBP_WEBSERVICES_URL);
        String tenantId = this.pluginMap.get(ConstantsPlugin.TENANTID);
        String apiId = Utilities.getAttributeFromPropertiesFile(this.pluginMap, "BusinessBotPlatform.Account.ApiId");
        String apiKey = Utilities.getAttributeFromPropertiesFile(this.pluginMap, "BusinessBotPlatform.Account.ApiKey");
        String url = bbpWebservicesBaseUrl + tenantId + ":" + apiId + ":" + apiKey + "/setCallback";
        logger.info((Object)("Chatbot callback url: [" + url + "]"));
        String responseContent = WebService.sendHttpPostRequest(url, chatbotCallback.toJson().toString());
        logger.info((Object)("Response from BBP: [" + responseContent + "]"));
        if (responseContent != null) {
            JSONObject result = new JSONObject(responseContent);
            String receiptId = result.getString("description");
            if (receiptId != null && receiptId.length() != 0) {
                return receiptId;
            }
            logger.error((Object)("Unexpected receiptId: [" + receiptId + "]"));
            return null;
        }
        logger.error((Object)("Unexpected response from BBP webservice: [" + responseContent + "]"));
        return null;
    }

    public boolean unregisterChatbotCallback(int callbackId) throws Exception {
        String bbpWebservicesBaseUrl = this.pluginMap.get(ConstantsPlugin.BBP_WEBSERVICES_URL);
        String tenantId = this.pluginMap.get(ConstantsPlugin.TENANTID);
        String apiId = Utilities.getAttributeFromPropertiesFile(this.pluginMap, "BusinessBotPlatform.Account.ApiId");
        String apiKey = Utilities.getAttributeFromPropertiesFile(this.pluginMap, "BusinessBotPlatform.Account.ApiKey");
        String url = bbpWebservicesBaseUrl + tenantId + ":" + apiId + ":" + apiKey + "/removeCallback/" + callbackId;
        logger.info((Object)("Chatbot callback url: [" + url + "]"));
        String responseContent = WebService.sendHttpGetRequest(url, null, "application/json", "en-US");
        logger.info((Object)("Response from BBP: [" + responseContent + "]"));
        if (responseContent != null) {
            JSONObject result = new JSONObject(responseContent);
            int code = result.getInt("code");
            if (code == 200) {
                return true;
            }
            logger.error((Object)("Unexpected return code: [" + code + "]"));
            return false;
        }
        logger.error((Object)("Unexpected response from BBP webservice: [" + responseContent + "]"));
        return false;
    }

    public List<Userstate> getUserstate(Userstate userstate) {
        String bbpWebservicesBaseUrl = this.pluginMap.get(ConstantsPlugin.BBP_WEBSERVICES_URL);
        String tenantId = this.pluginMap.get(ConstantsPlugin.TENANTID);
        String apiId = Utilities.getAttributeFromPropertiesFile(this.pluginMap, "BusinessBotPlatform.Account.ApiId");
        String apiKey = Utilities.getAttributeFromPropertiesFile(this.pluginMap, "BusinessBotPlatform.Account.ApiKey");
        String url = bbpWebservicesBaseUrl + tenantId + ":" + apiId + ":" + apiKey + "/getUserstate";
        logger.info((Object)("Url: [" + url + "]"));
        String responseContent = WebService.sendHttpPostRequest(url, userstate.toJson().toString());
        logger.info((Object)("Response from BBP: [" + responseContent + "]"));
        if (responseContent != null) {
            JSONObject result = new JSONObject(responseContent);
            int code = result.getInt("code");
            if (code == 200) {
                ArrayList<Userstate> userstates = new ArrayList<Userstate>();
                JSONArray jsonArrayTaskSchedules = result.getJSONArray("result");
                if (jsonArrayTaskSchedules != null && jsonArrayTaskSchedules.length() != 0) {
                    for (int t = 0; t < jsonArrayTaskSchedules.length(); ++t) {
                        userstates.add(new Userstate(jsonArrayTaskSchedules.getJSONObject(t)));
                    }
                } else {
                    System.out.println("No ChatbotSchedules found");
                }
                return userstates;
            }
            System.err.println("Unexpected return code: [" + code + "]");
            return null;
        }
        logger.error((Object)("Unexpected response from BBP webservice: [" + responseContent + "]"));
        return null;
    }

    public List<ChatbotTaskSchedule> getChatbotCallbacks() throws Exception {
        String bbpWebservicesBaseUrl = this.pluginMap.get(ConstantsPlugin.BBP_WEBSERVICES_URL);
        String tenantId = this.pluginMap.get(ConstantsPlugin.TENANTID);
        String apiId = Utilities.getAttributeFromPropertiesFile(this.pluginMap, "BusinessBotPlatform.Account.ApiId");
        String apiKey = Utilities.getAttributeFromPropertiesFile(this.pluginMap, "BusinessBotPlatform.Account.ApiKey");
        String url = bbpWebservicesBaseUrl + tenantId + ":" + apiId + ":" + apiKey + "/getCallbacks";
        logger.info((Object)("Chatbot callback url: [" + url + "]"));
        String responseContent = WebService.sendHttpGetRequest(url, null, "application/json", "en-US");
        logger.info((Object)("Response from BBP: [" + responseContent + "]"));
        if (responseContent != null) {
            JSONObject result = new JSONObject(responseContent);
            int code = result.getInt("code");
            if (code == 200) {
                ArrayList<ChatbotTaskSchedule> taskSchedules = new ArrayList<ChatbotTaskSchedule>();
                JSONArray jsonArrayTaskSchedules = result.getJSONArray("result");
                if (jsonArrayTaskSchedules != null && jsonArrayTaskSchedules.length() != 0) {
                    for (int t = 0; t < jsonArrayTaskSchedules.length(); ++t) {
                        taskSchedules.add(new ChatbotTaskSchedule(jsonArrayTaskSchedules.getJSONObject(t)));
                    }
                    logger.info((Object)("Returning [" + (taskSchedules != null && taskSchedules.size() != 0 ? Integer.valueOf(taskSchedules.size()) : "0") + "] business objects"));
                } else {
                    logger.info((Object)"No ChatbotSchedules found");
                }
                return taskSchedules;
            }
            logger.error((Object)("Unexpected return code: [" + code + "]"));
            return null;
        }
        logger.error((Object)("Unexpected response from BBP webservice: [" + responseContent + "]"));
        return null;
    }

    public String registerFileToBBPFileStore(String localImageFile) throws Exception {
        try {
            Throwable throwable;
            String bbpWebservicesBaseUrl = this.pluginMap.get(ConstantsPlugin.BBP_WEBSERVICES_URL);
            String tenantId = this.pluginMap.get(ConstantsPlugin.TENANTID);
            String apiId = Utilities.getAttributeFromPropertiesFile(this.pluginMap, "BusinessBotPlatform.Account.ApiId");
            String apiKey = Utilities.getAttributeFromPropertiesFile(this.pluginMap, "BusinessBotPlatform.Account.ApiKey");
            String url = bbpWebservicesBaseUrl + tenantId + ":" + apiId + ":" + apiKey + "/uploadFile";
            logger.info((Object)("Register File to url: [" + url + "]"));
            String charset = "UTF-8";
            String param = "value";
            File binaryFile = new File(localImageFile);
            String boundary = Long.toHexString(System.currentTimeMillis());
            String CRLF = "\r\n";
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
            URLConnection connection = new URL(url).openConnection();
            connection.setDoOutput(true);
            connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            try (OutputStream output = connection.getOutputStream();){
                throwable = null;
                try (PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(output, charset), true);){
                    writer.append("--" + boundary).append(CRLF);
                    writer.append("Content-Disposition: form-data; name=\"param\"").append(CRLF);
                    writer.append("Content-Type: text/plain; charset=" + charset).append(CRLF);
                    writer.append(CRLF).append(param).append(CRLF).flush();
                    writer.append("--" + boundary).append(CRLF);
                    writer.append("Content-Disposition: form-data; name=\"file\"; filename=\"" + binaryFile.getName() + "\"").append(CRLF);
                    writer.append("Content-Type: " + URLConnection.guessContentTypeFromName(binaryFile.getName())).append(CRLF);
                    writer.append("Content-Transfer-Encoding: binary").append(CRLF);
                    writer.append(CRLF).flush();
                    Files.copy(binaryFile.toPath(), output);
                    output.flush();
                    writer.append(CRLF).flush();
                    writer.append("--" + boundary + "--").append(CRLF).flush();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            int responseCode = ((HttpURLConnection)connection).getResponseCode();
            logger.info((Object)("Response code: [" + responseCode + "]"));
            StringBuilder builder = new StringBuilder();
            throwable = null;
            try (BufferedReader in = new BufferedReader(new InputStreamReader(((HttpURLConnection)connection).getInputStream()));){
                String line;
                while ((line = in.readLine()) != null) {
                    builder.append(line);
                }
                in.close();
            }
            catch (Throwable line) {
                throwable = line;
                throw line;
            }
            String responseContent = builder.toString();
            logger.info((Object)("Response from BBP FileStore: [" + responseContent + "]"));
            if (responseContent != null) {
                JSONObject result = new JSONObject(responseContent);
                String fileUUID = result.getString("description");
                if (fileUUID != null && fileUUID.length() != 0) {
                    return fileUUID;
                }
                logger.error((Object)("Unexpected fileUUID: [" + fileUUID + "]"));
                return null;
            }
            logger.error((Object)("Unexpected response from BBP FileStore: [" + responseContent + "]"));
            return null;
        }
        catch (IOException e) {
            logger.error((Object)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendHttpGetRequest(String targetURL, String urlParameters, String contentType, String language) {
        HttpURLConnection connection = null;
        try {
            String line;
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
            URL url = new URL(targetURL);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Content-Type", contentType);
            connection.setRequestProperty("User-Agent", "BBP-API-COMMON/1.0");
            connection.setRequestProperty("Content-Language", language);
            connection.setUseCaches(false);
            connection.setDoOutput(true);
            InputStream is = connection.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(is));
            StringBuilder response = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                response.append(line);
                response.append('\r');
            }
            rd.close();
            String string = response.toString();
            return string;
        }
        catch (Exception e) {
            logger.error((Object)e);
            String string = null;
            return string;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendHttpGetRequestWithBasicAuthentication(String targetURL, String username, String password) {
        HttpURLConnection connection = null;
        try {
            String line;
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
            URL url = new URL(targetURL);
            connection = (HttpURLConnection)url.openConnection();
            String userpass = username + ":" + password;
            String basicAuth = "Basic " + DatatypeConverter.printBase64Binary((byte[])userpass.getBytes());
            connection.setRequestProperty("Authorization", basicAuth);
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            connection.setRequestProperty("User-Agent", "BBP-API-COMMON/1.0");
            connection.setRequestProperty("Content-Language", "en-US");
            connection.setUseCaches(false);
            connection.setDoOutput(true);
            InputStream is = connection.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(is));
            StringBuilder response = new StringBuilder();
            while ((line = rd.readLine()) != null) {
                response.append(line);
                response.append('\r');
            }
            rd.close();
            String string = response.toString();
            return string;
        }
        catch (Exception e) {
            logger.error((Object)e);
            String string = null;
            return string;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendHttpPostRequest(String targetURL, String body) {
        HttpURLConnection connection = null;
        String responseData = null;
        try {
            String inputLine;
            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkClientTrusted(X509Certificate[] certs, String authType) {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] certs, String authType) {
                }
            }};
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier allHostsValid = new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(allHostsValid);
            URL url = new URL(targetURL);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("User-Agent", "BBP-API-COMMON/1.0");
            connection.setRequestProperty("Content-Language", "en-US");
            connection.setRequestProperty("Accept-Language", "en-US,en;q=0.5");
            connection.setUseCaches(false);
            connection.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            wr.writeBytes(body);
            wr.flush();
            wr.close();
            int responseCode = connection.getResponseCode();
            logger.info((Object)("Sending [POST] request to URL: [" + url + "]"));
            logger.info((Object)("Post parameters: [" + body + "]"));
            logger.info((Object)("Response Code: [" + responseCode + "]"));
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            responseData = response.toString();
            logger.info((Object)responseData);
        }
        catch (Exception e) {
            logger.error((Object)("Unable to perform HTTP POST request to url [" + targetURL + "]"));
            logger.error((Object)("Post parameters: [" + body + "]"));
            logger.error((Object)e);
            String string = null;
            return string;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return responseData;
    }
}

