package test.de.citunius.rivescript;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import com.rivescript.Config;
import com.rivescript.RiveScript;

/**
 * Alternatives and Optionals
 * 
 * <p>What if you want to use something like a wildcard, 
 * but you want to limit the possible words to a select few? 
 * This is where optionals come into play.</p>
 *
 */
public class MainMyBot03_Alternations {

	/**
	 * Example dialogue:
	 * 
	    User: what is your cell phone number
		Bot:  You can call my cell number at +49 (0) 6131 1234-1234.
		User: I am very tired
		Bot:  I'm sorry to hear that you are very tired.
		User: i like the color blue
		Bot:  Oh I like blue too!
	 */
	public static void main(String[] args) {
		// If the RiveScript bot files are in a directory <Project> then a bot named named mybot03 should use the directories:
		// | Directory | Contents | 
		// |:----------|:---------| 
		// | <Project>/resources/rivescript/bots/mybot03 	| .rive Files | 
		String botname="mybot03"; 
		String path=System.getProperty("user.dir")+File.separator+"resources"+File.separator+"rivescript"+File.separator+"bots"+File.separator+botname+File.separator;
		String exitCommand = "bye";
		String request = null;
		
		System.out.println("Path: ["+path+"]");
		System.out.println("--- THIS IS "+botname.toUpperCase()+" EXAMPLE (Test Case: Alternatives and Optionals) ---");
		System.out.println("Bot:  Ask me something :-) (..or type '"+exitCommand+"' to end this conversation)");
		
		// To enable UTF-8 mode, you'd have initialized the bot like:
		RiveScript bot = new RiveScript(Config.utf8());

		// Load a directory full of RiveScript documents (.rive files)
		File file = new File(path);
		bot.loadDirectory(file);
		
		// Sort the replies after loading them!
		bot.sortReplies();
		
		// Store all user requests to this list
		List<String> list = new ArrayList<String>();
		// Prepare scanner to read from console
		Scanner sn = new Scanner(System.in);
		// Loop until user wants to end this conversation
		while (true) {
			request = sn.nextLine();
			System.out.println("User: "+request);
			// Chat with the bot / Get a reply
			String reply = bot.reply("user", request);
			System.out.println("Bot:  "+reply);
		    list.add(request);
		    if (request != null && request.equals(exitCommand)) {
		    	sn.close();
		    	break;
		    }
		}
		System.out.println("-- Bot session end. --");
	}

}
