package test.de.citunius.rivescript;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import com.rivescript.Config;
import com.rivescript.RiveScript;

/**
 * Arrays in Triggers
 * 
 * <p>Making your bot always respond exactly the same way to something the user 
 * says will get boring really quickly. For this reason, RiveScript makes it easy 
 * to add random responses to a trigger!
 * 
 * Getting random responses is as easy as entering multiple 
 * Response commands for the same trigger.</p>
 *
 */
public class MainMyBot05_ArraysInTriggers {

	/**
	 * Example dialogue:
	 * 
	    User: what color is my blue shirt?
		Bot:  Your shirt is blue, silly!
	 */
	public static void main(String[] args) {
		// If the RiveScript bot files are in a directory <Project> then a bot named named mybot05 should use the directories:
		// | Directory | Contents | 
		// |:----------|:---------| 
		// | <Project>/resources/rivescript/bots/mybot05 	| .rive Files | 
		String botname="mybot05"; 
		String path=System.getProperty("user.dir")+File.separator+"resources"+File.separator+"rivescript"+File.separator+"bots"+File.separator+botname+File.separator;
		String exitCommand = "bye";
		String request = null;
		
		System.out.println("Path: ["+path+"]");
		System.out.println("--- THIS IS "+botname.toUpperCase()+" EXAMPLE (Test Case: Random Replies) ---");
		System.out.println("Bot:  Ask me something :-) (..or type '"+exitCommand+"' to end this conversation)");
		
		// To enable UTF-8 mode, you'd have initialized the bot like:
		RiveScript bot = new RiveScript(Config.utf8());

		// Load a directory full of RiveScript documents (.rive files)
		File file = new File(path);
		bot.loadDirectory(file);
		
		// Sort the replies after loading them!
		bot.sortReplies();
		
		// Store all user requests to this list
		List<String> list = new ArrayList<String>();
		// Prepare scanner to read from console
		Scanner sn = new Scanner(System.in);
		// Loop until user wants to end this conversation
		while (true) {
			request = sn.nextLine();
			System.out.println("User: "+request);
			// Chat with the bot / Get a reply
			String reply = bot.reply("user", request);
			System.out.println("Bot:  "+reply);
		    list.add(request);
		    if (request != null && request.equals(exitCommand)) {
		    	sn.close();
		    	break;
		    }
		}
		System.out.println("-- Bot session end. --");
	}

}
