package test.de.citunius.rivescript;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import com.rivescript.Config;
import com.rivescript.RiveScript;

/**
 * Wildcards
 *
 * <p>Wildcards are great, but what if you want to restrict what a wildcard is allowed to match? 
 * For example, the trigger "i am * years old" would match a message like "I am twenty four years old" 
 * just as well as "I am 24 years old".
 * 
 * There are two other wildcard symbols you may use. The # symbol is a wildcard that 
 * will only match a number. The _ symbol is one that will only match a word with 
 * no numbers or spaces in it.
 * 
 * You can have multiple triggers that look the same but use different wildcards and 
 * they will work how you'd expect:
 */
public class MainMyBot02_Wildcards {

	/**
	 * Example dialogue:
	 * 
	    User: My name is Max
		Bot:  max, nice to meet you.
		User: i am 23 years old
		Bot:  A lot of people are 23 years old.
		User: i am from Mainz
		Bot:  What is it like to live in mainz?	
	 */
	public static void main(String[] args) {
		// If the RiveScript bot files are in a directory <Project> then a bot named named mybot02 should use the directories:
		// | Directory | Contents | 
		// |:----------|:---------| 
		// | <Project>/resources/rivescript/bots/mybot02 	| .rive Files | 
		String botname="mybot02"; 
		String path=System.getProperty("user.dir")+File.separator+"resources"+File.separator+"rivescript"+File.separator+"bots"+File.separator+botname+File.separator;
		String exitCommand = "bye";
		String request = null;
		
		System.out.println("Path: ["+path+"]");
		System.out.println("--- THIS IS "+botname.toUpperCase()+" EXAMPLE (Test Case: Wildcards) ---");
		System.out.println("Bot:  Ask me something :-) (..or type '"+exitCommand+"' to end this conversation)");
		
		// To enable UTF-8 mode, you'd have initialized the bot like:
		RiveScript bot = new RiveScript(Config.utf8());

		// Load a directory full of RiveScript documents (.rive files)
		File file = new File(path);
		bot.loadDirectory(file);
		
		// Sort the replies after loading them!
		bot.sortReplies();
		
		// Store all user requests to this list
		List<String> list = new ArrayList<String>();
		// Prepare scanner to read from console
		Scanner sn = new Scanner(System.in);
		// Loop until user wants to end this conversation
		while (true) {
			request = sn.nextLine();
			System.out.println("User: "+request);
			// Chat with the bot / Get a reply
			String reply = bot.reply("user", request);
			System.out.println("Bot:  "+reply);
		    list.add(request);
		    if (request != null && request.equals(exitCommand)) {
		    	sn.close();
		    	break;
		    }
		}
		System.out.println("-- Bot session end. --");
	}

}
