package test.de.citunius.rivescript;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import com.rivescript.Config;
import com.rivescript.RiveScript;

/**
 * Hello World example
 *
 * <p>Let's write our first few lines of RiveScript code!</p>
 */
public class MainMyBot01_HelloWorld {

	/**
	 * Example dialogue:
	 * 
	    User: hello luno
		Bot:  Hello, User!
		User: bye
		Bot:  ERR: No Reply Matched		
	 */
	public static void main(String[] args) {
		// If the RiveScript bot files are in a directory <Project> then a bot named named mybot01 should use the directories:
		// | Directory | Contents | 
		// |:----------|:---------| 
		// | <Project>/resources/rivescript/bots/mybot01 	| .rive Files | 
		String botname="mybot01"; 
		String path=System.getProperty("user.dir")+File.separator+"resources"+File.separator+"rivescript"+File.separator+"bots"+File.separator+botname+File.separator;
		String exitCommand = "bye";
		String request = null;
		
		System.out.println("Path: ["+path+"]");
		System.out.println("--- THIS IS "+botname.toUpperCase()+" EXAMPLE (Test Case: HelloWorld) ---");
		System.out.println("Bot:  Ask me something :-) (..or type '"+exitCommand+"' to end this conversation)");
		
		// To enable UTF-8 mode, you'd have initialized the bot like:
		RiveScript bot = new RiveScript(Config.utf8());

		// Load a directory full of RiveScript documents (.rive files)
		File file = new File(path);
		bot.loadDirectory(file);
		
		// Sort the replies after loading them!
		bot.sortReplies();
		
		// Store all user requests to this list
		List<String> list = new ArrayList<String>();
		// Prepare scanner to read from console
		Scanner sn = new Scanner(System.in);
		// Loop until user wants to end this conversation
		while (true) {
			request = sn.nextLine();
			System.out.println("User: "+request);
			// Chat with the bot / Get a reply
			String reply = bot.reply("user", request);
			System.out.println("Bot:  "+reply);
		    list.add(request);
		    if (request != null && request.equals(exitCommand)) {
		    	sn.close();
		    	break;
		    }
		}
		System.out.println("-- Bot session end. --");
	}

}
